/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ProjectBackedModule;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.component.DefaultSoftwareComponentContainer;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.DefaultProjectLayout;
import org.gradle.api.internal.file.DefaultSourceDirectorySetFactory;
import org.gradle.api.internal.file.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.initialization.DefaultScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.model.DefaultObjectFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.plugins.DefaultPluginManager;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.plugins.RuleBasedPluginTarget;
import org.gradle.api.internal.project.DefaultAntBuilderFactory;
import org.gradle.api.internal.project.DeferredProjectConfiguration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ant.DefaultAntLoggingAdapterFactory;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskContainerFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskStatistics;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.configuration.project.DefaultProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextResourceLoader;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.PluginServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.typeconversion.DefaultTypeConverter;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.model.internal.registry.DefaultModelRegistry;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.normalization.InputNormalizationHandler;
import org.gradle.normalization.internal.DefaultInputNormalizationHandler;
import org.gradle.normalization.internal.DefaultRuntimeClasspathNormalization;
import org.gradle.normalization.internal.RuntimeClasspathNormalizationInternal;
import org.gradle.process.internal.ExecFactory;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.internal.DefaultToolingModelBuilderRegistry;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectScopeServices
extends DefaultServiceRegistry {
    private final ProjectInternal project;
    private final Factory<LoggingManagerInternal> loggingManagerInternalFactory;

    public ProjectScopeServices(final ServiceRegistry parent, final ProjectInternal project, Factory<LoggingManagerInternal> loggingManagerInternalFactory) {
        super(new ServiceRegistry[]{parent});
        this.project = project;
        this.loggingManagerInternalFactory = loggingManagerInternalFactory;
        this.register((Action)new Action<ServiceRegistration>(){

            public void execute(ServiceRegistration registration) {
                registration.add(DomainObjectContext.class, (Object)project);
                ((DependencyManagementServices)parent.get(DependencyManagementServices.class)).addDslServices(registration);
                for (PluginServiceRegistry pluginServiceRegistry : parent.getAll(PluginServiceRegistry.class)) {
                    pluginServiceRegistry.registerProjectServices(registration);
                }
            }
        });
    }

    protected PluginRegistry createPluginRegistry(PluginRegistry rootRegistry) {
        PluginRegistry parentRegistry = this.project.getParent() == null ? rootRegistry.createChild(this.project.getBaseClassLoaderScope()) : (PluginRegistry)this.project.getParent().getServices().get(PluginRegistry.class);
        return parentRegistry.createChild(this.project.getClassLoaderScope());
    }

    protected DeferredProjectConfiguration createDeferredProjectConfiguration() {
        return new DeferredProjectConfiguration(this.project);
    }

    protected FileResolver createFileResolver(Factory<PatternSet> patternSetFactory) {
        return new BaseDirFileResolver((FileSystem)this.get(FileSystem.class), this.project.getProjectDir(), patternSetFactory);
    }

    protected SourceDirectorySetFactory createSourceDirectorySetFactory(FileResolver fileResolver, DirectoryFileTreeFactory directoryFileTreeFactory) {
        return new DefaultSourceDirectorySetFactory(fileResolver, directoryFileTreeFactory);
    }

    protected LoggingManagerInternal createLoggingManager() {
        return (LoggingManagerInternal)this.loggingManagerInternalFactory.create();
    }

    protected ProjectConfigurationActionContainer createProjectConfigurationActionContainer() {
        return new DefaultProjectConfigurationActionContainer();
    }

    protected DefaultFileOperations createFileOperations(FileResolver fileResolver, TemporaryFileProvider temporaryFileProvider, Instantiator instantiator, FileLookup fileLookup, DirectoryFileTreeFactory directoryFileTreeFactory, StreamHasher streamHasher, FileHasher fileHasher, ExecFactory execFactory, TextResourceLoader textResourceLoader) {
        return new DefaultFileOperations(fileResolver, this.project.getTasks(), temporaryFileProvider, instantiator, fileLookup, directoryFileTreeFactory, streamHasher, fileHasher, execFactory, textResourceLoader);
    }

    protected ExecFactory decorateExecFactory(ExecFactory execFactory) {
        return execFactory.forContext((FileResolver)this.get(FileResolver.class), ((InstantiatorFactory)this.get(InstantiatorFactory.class)).decorate());
    }

    protected TemporaryFileProvider createTemporaryFileProvider() {
        return new DefaultTemporaryFileProvider(new Factory<File>(){

            public File create() {
                return new File(ProjectScopeServices.this.project.getBuildDir(), "tmp");
            }
        });
    }

    protected Factory<AntBuilder> createAntBuilderFactory() {
        return new DefaultAntBuilderFactory(this.project, new DefaultAntLoggingAdapterFactory());
    }

    protected ToolingModelBuilderRegistry decorateToolingModelRegistry(ToolingModelBuilderRegistry buildScopedToolingModelBuilders) {
        return new DefaultToolingModelBuilderRegistry(buildScopedToolingModelBuilders);
    }

    protected PluginManagerInternal createPluginManager(Instantiator instantiator, InstantiatorFactory instantiatorFactory, BuildOperationExecutor buildOperationExecutor) {
        RuleBasedPluginTarget target = new RuleBasedPluginTarget(this.project, (ModelRuleExtractor)this.get(ModelRuleExtractor.class), (ModelRuleSourceDetector)this.get(ModelRuleSourceDetector.class));
        return (PluginManagerInternal)instantiator.newInstance(DefaultPluginManager.class, new Object[]{this.get(PluginRegistry.class), instantiatorFactory.inject((ServiceRegistry)this), target, buildOperationExecutor});
    }

    protected ITaskFactory createTaskFactory(ITaskFactory parentFactory) {
        return parentFactory.createChild(this.project, ((InstantiatorFactory)this.get(InstantiatorFactory.class)).injectAndDecorate((ServiceRegistry)this));
    }

    protected Factory<TaskContainerInternal> createTaskContainerInternal(TaskStatistics taskStatistics) {
        return new DefaultTaskContainerFactory((ModelRegistry)this.get(ModelRegistry.class), (Instantiator)this.get(Instantiator.class), (ITaskFactory)this.get(ITaskFactory.class), this.project, (ProjectAccessListener)this.get(ProjectAccessListener.class), taskStatistics);
    }

    protected SoftwareComponentContainer createSoftwareComponentContainer() {
        Instantiator instantiator = (Instantiator)this.get(Instantiator.class);
        return (SoftwareComponentContainer)instantiator.newInstance(DefaultSoftwareComponentContainer.class, new Object[]{instantiator});
    }

    protected ProjectFinder createProjectFinder() {
        return new ProjectFinder(){

            public ProjectInternal getProject(String path) {
                return ProjectScopeServices.this.project.project(path);
            }

            public ProjectInternal findProject(String path) {
                return ProjectScopeServices.this.project.findProject(path);
            }
        };
    }

    protected ModelRegistry createModelRegistry(ModelRuleExtractor ruleExtractor) {
        return new DefaultModelRegistry(ruleExtractor, this.project.getPath());
    }

    protected ScriptHandler createScriptHandler() {
        DefaultScriptHandlerFactory factory = new DefaultScriptHandlerFactory((DependencyManagementServices)this.get(DependencyManagementServices.class), (FileResolver)this.get(FileResolver.class), (DependencyMetaDataProvider)this.get(DependencyMetaDataProvider.class), (ScriptClassPathResolver)this.get(ScriptClassPathResolver.class));
        return factory.create(this.project.getBuildScriptSource(), this.project.getClassLoaderScope(), new ScriptScopedContext(this.project));
    }

    protected DependencyMetaDataProvider createDependencyMetaDataProvider() {
        return new ProjectBackedModuleMetaDataProvider();
    }

    protected ServiceRegistryFactory createServiceRegistryFactory(ServiceRegistry services) {
        return new ServiceRegistryFactory(){

            public ServiceRegistry createFor(Object domainObject) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected ComponentRegistry createComponentRegistry() {
        return new ComponentRegistry();
    }

    protected TypeConverter createTypeConverter(PathToFileResolver fileResolver) {
        return new DefaultTypeConverter(fileResolver);
    }

    protected RuntimeClasspathNormalizationInternal createRuntimeClasspathNormalizationStrategy(Instantiator instantiator) {
        return (RuntimeClasspathNormalizationInternal)instantiator.newInstance(DefaultRuntimeClasspathNormalization.class, new Object[0]);
    }

    protected InputNormalizationHandler createInputNormalizationHandler(Instantiator instantiator, RuntimeClasspathNormalizationInternal runtimeClasspathNormalizationStrategy) {
        return (InputNormalizationHandler)instantiator.newInstance(DefaultInputNormalizationHandler.class, new Object[]{runtimeClasspathNormalizationStrategy});
    }

    protected DefaultProjectLayout createProjectLayout(FileResolver fileResolver) {
        return new DefaultProjectLayout(this.project.getProjectDir(), fileResolver, this.project.getTasks());
    }

    protected ConfigurationTargetIdentifier createConfigurationTargetIdentifier() {
        return ConfigurationTargetIdentifier.of(this.project);
    }

    protected ObjectFactory createObjectFactory(InstantiatorFactory instantiatorFactory) {
        Instantiator instantiator = instantiatorFactory.injectAndDecorate((ServiceRegistry)this);
        return new DefaultObjectFactory(instantiator, NamedObjectInstantiator.INSTANCE);
    }

    private class ProjectBackedModuleMetaDataProvider
    implements DependencyMetaDataProvider {
        private ProjectBackedModuleMetaDataProvider() {
        }

        public Module getModule() {
            return new ProjectBackedModule(ProjectScopeServices.this.project);
        }
    }

    private class ScriptScopedContext
    implements DomainObjectContext {
        private final DomainObjectContext delegate;

        public ScriptScopedContext(DomainObjectContext delegate) {
            this.delegate = delegate;
        }

        public Path identityPath(String name) {
            return this.delegate.identityPath(name);
        }

        public Path projectPath(String name) {
            return this.delegate.projectPath(name);
        }

        public Path getProjectPath() {
            return this.delegate.getProjectPath();
        }

        public Path getBuildPath() {
            return this.delegate.getBuildPath();
        }

        public boolean isScript() {
            return true;
        }
    }
}

