/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.component.ComponentWithCoordinates;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.provider.Provider;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.util.GUtil;

public class NativeVariantIdentity
implements SoftwareComponentInternal,
ComponentWithCoordinates {
    private final String name;
    private final Provider<String> baseName;
    private final Provider<String> group;
    private final Provider<String> version;
    private final boolean debuggable;
    private final boolean optimized;
    private final OperatingSystemFamily operatingSystemFamily;
    private final UsageContext linkUsage;
    private final UsageContext runtimeUsage;
    private final Set<UsageContext> usageContexts;

    public NativeVariantIdentity(String name, Provider<String> baseName, Provider<String> group, Provider<String> version, boolean debuggable, boolean optimized, OperatingSystemFamily operatingSystemFamily, UsageContext linkUsage, UsageContext runtimeUsage) {
        this.name = name;
        this.baseName = baseName;
        this.group = group;
        this.version = version;
        this.debuggable = debuggable;
        this.optimized = optimized;
        this.operatingSystemFamily = operatingSystemFamily;
        this.linkUsage = linkUsage;
        this.runtimeUsage = runtimeUsage;
        this.usageContexts = Sets.newLinkedHashSet();
        if (linkUsage != null) {
            this.usageContexts.add(linkUsage);
        }
        if (runtimeUsage != null) {
            this.usageContexts.add(runtimeUsage);
        }
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public OperatingSystemFamily getOperatingSystemFamily() {
        return this.operatingSystemFamily;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return new DefaultModuleVersionIdentifier((String)this.group.get(), (String)this.baseName.get() + "_" + GUtil.toWords((CharSequence)this.name, (char)'_'), (String)this.version.get());
    }

    public Set<? extends UsageContext> getUsages() {
        return this.usageContexts;
    }

    public String getName() {
        return this.name;
    }

    public UsageContext getRuntimeUsageContext() {
        return this.runtimeUsage;
    }

    public UsageContext getLinkUsageContext() {
        return this.linkUsage;
    }
}

