/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.SelectionReasonHelper;

public class DependencyReportHeader
implements RenderableDependency {
    private final DependencyEdge dependency;
    private final ResolvedVariantResult selectedVariant;

    public DependencyReportHeader(DependencyEdge dependency, ResolvedVariantResult extraDetails) {
        this.dependency = dependency;
        this.selectedVariant = extraDetails;
    }

    public ComponentIdentifier getId() {
        return this.dependency.getActual();
    }

    @Override
    public String getName() {
        return this.getId().getDisplayName();
    }

    @Override
    public String getDescription() {
        return SelectionReasonHelper.getReasonDescription(this.dependency.getReason());
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return this.dependency.isResolvable() ? RenderableDependency.ResolutionState.RESOLVED : RenderableDependency.ResolutionState.FAILED;
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        return Collections.emptySet();
    }

    @Override
    public ResolvedVariantResult getResolvedVariant() {
        return this.selectedVariant;
    }
}

