/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.plugins.GroovyJarFile;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Cast;

@Incubating
public class GroovyRuntime {
    private final Project project;

    public GroovyRuntime(Project project) {
        this.project = project;
    }

    public FileCollection inferGroovyClasspath(final Iterable<File> classpath) {
        return new LazilyInitializedFileCollection(){

            public String getDisplayName() {
                return "Groovy runtime classpath";
            }

            public FileCollection createDelegate() {
                GroovyJarFile groovyJar = GroovyRuntime.this.findGroovyJarFile(classpath);
                if (groovyJar == null) {
                    throw new GradleException(String.format("Cannot infer Groovy class path because no Groovy Jar was found on class path: %s", Iterables.toString((Iterable)classpath)));
                }
                if (groovyJar.isGroovyAll()) {
                    return (FileCollection)Cast.cast(FileCollectionInternal.class, (Object)GroovyRuntime.this.project.getLayout().files(new Object[]{groovyJar.getFile()}));
                }
                if (GroovyRuntime.this.project.getRepositories().isEmpty()) {
                    throw new GradleException("Cannot infer Groovy class path because no repository is declared for the project.");
                }
                String notation = groovyJar.getDependencyNotation();
                ArrayList dependencies = Lists.newArrayList();
                dependencies.add(GroovyRuntime.this.project.getDependencies().create((Object)notation));
                if (groovyJar.getVersion().getMajor() >= 2) {
                    dependencies.add(GroovyRuntime.this.project.getDependencies().create((Object)notation.replace(":groovy:", ":groovy-ant:")));
                }
                return GroovyRuntime.this.project.getConfigurations().detachedConfiguration(dependencies.toArray(new Dependency[0]));
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                if (classpath instanceof Buildable) {
                    context.add((Object)classpath);
                }
            }
        };
    }

    private GroovyJarFile findGroovyJarFile(Iterable<File> classpath) {
        if (classpath == null) {
            return null;
        }
        for (File file : classpath) {
            GroovyJarFile groovyJar = GroovyJarFile.parse(file);
            if (groovyJar == null) continue;
            return groovyJar;
        }
        return null;
    }
}

