/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.protocol;

import java.util.UUID;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.exec.BuildActionParameters;

public class Build
extends Command {
    private final BuildAction action;
    private final BuildClientMetaData buildClientMetaData;
    private final long startTime;
    private final BuildActionParameters parameters;

    public Build(UUID identifier, byte[] token, BuildAction action, BuildClientMetaData buildClientMetaData, long startTime, BuildActionParameters parameters) {
        super(identifier, token);
        this.action = action;
        this.buildClientMetaData = buildClientMetaData;
        this.startTime = startTime;
        this.parameters = parameters;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public BuildClientMetaData getBuildClientMetaData() {
        return this.buildClientMetaData;
    }

    public BuildRequestMetaData getBuildRequestMetaData() {
        return new DefaultBuildRequestMetaData(this.buildClientMetaData, this.startTime);
    }

    public BuildAction getAction() {
        return this.action;
    }

    public BuildActionParameters getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.getIdentifier() + ", currentDir=" + this.parameters.getCurrentDir() + '}';
    }
}

