/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutionSnapshotSerializer
extends AbstractSerializer<HistoricalTaskExecution> {
    private final InputPropertiesSerializer inputPropertiesSerializer;
    private final Serializer<FileCollectionSnapshot> fileCollectionSnapshotSerializer;

    TaskExecutionSnapshotSerializer(Serializer<FileCollectionSnapshot> fileCollectionSnapshotSerializer) {
        this.fileCollectionSnapshotSerializer = fileCollectionSnapshotSerializer;
        this.inputPropertiesSerializer = new InputPropertiesSerializer();
    }

    public HistoricalTaskExecution read(Decoder decoder) throws Exception {
        boolean successful = decoder.readBoolean();
        OriginTaskExecutionMetadata originExecutionMetadata = new OriginTaskExecutionMetadata(UniqueId.from((String)decoder.readString()), decoder.readLong());
        ImmutableSortedMap<String, FileCollectionSnapshot> inputFilesSnapshots = this.readSnapshots(decoder);
        ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesSnapshots = this.readSnapshots(decoder);
        ImplementationSnapshot taskImplementation = TaskExecutionSnapshotSerializer.readImplementation(decoder);
        int taskActionsCount = decoder.readSmallInt();
        ImmutableList.Builder taskActionImplementationsBuilder = ImmutableList.builder();
        for (int j = 0; j < taskActionsCount; ++j) {
            ImplementationSnapshot actionImpl = TaskExecutionSnapshotSerializer.readImplementation(decoder);
            taskActionImplementationsBuilder.add((Object)actionImpl);
        }
        ImmutableList taskActionImplementations = taskActionImplementationsBuilder.build();
        int cacheableOutputPropertiesCount = decoder.readSmallInt();
        ImmutableSortedSet.Builder cacheableOutputPropertiesBuilder = ImmutableSortedSet.naturalOrder();
        for (int j = 0; j < cacheableOutputPropertiesCount; ++j) {
            cacheableOutputPropertiesBuilder.add((Object)decoder.readString());
        }
        ImmutableSortedSet cacheableOutputProperties = cacheableOutputPropertiesBuilder.build();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = this.inputPropertiesSerializer.read(decoder);
        return new HistoricalTaskExecution(taskImplementation, (ImmutableList<ImplementationSnapshot>)taskActionImplementations, inputProperties, (ImmutableSortedSet<String>)cacheableOutputProperties, inputFilesSnapshots, outputFilesSnapshots, successful, originExecutionMetadata);
    }

    public void write(Encoder encoder, HistoricalTaskExecution execution) throws Exception {
        encoder.writeBoolean(execution.isSuccessful());
        encoder.writeString((CharSequence)execution.getOriginExecutionMetadata().getBuildInvocationId().asString());
        encoder.writeLong(execution.getOriginExecutionMetadata().getExecutionTime());
        this.writeSnapshots(encoder, (Map<String, FileCollectionSnapshot>)execution.getInputFilesSnapshot());
        this.writeSnapshots(encoder, (Map<String, FileCollectionSnapshot>)execution.getOutputFilesSnapshot());
        TaskExecutionSnapshotSerializer.writeImplementation(encoder, execution.getTaskImplementation());
        encoder.writeSmallInt(execution.getTaskActionImplementations().size());
        for (ImplementationSnapshot actionImpl : execution.getTaskActionImplementations()) {
            TaskExecutionSnapshotSerializer.writeImplementation(encoder, actionImpl);
        }
        encoder.writeSmallInt(execution.getOutputPropertyNamesForCacheKey().size());
        for (String outputFile : execution.getOutputPropertyNamesForCacheKey()) {
            encoder.writeString((CharSequence)outputFile);
        }
        this.inputPropertiesSerializer.write(encoder, (ImmutableMap<String, ValueSnapshot>)execution.getInputProperties());
    }

    private static ImplementationSnapshot readImplementation(Decoder decoder) throws IOException {
        String typeName = decoder.readString();
        HashCode classLoaderHash = decoder.readBoolean() ? HashCode.fromBytes((byte[])decoder.readBinary()) : null;
        return new ImplementationSnapshot(typeName, classLoaderHash);
    }

    private static void writeImplementation(Encoder encoder, ImplementationSnapshot implementation) throws IOException {
        encoder.writeString((CharSequence)implementation.getTypeName());
        if (implementation.hasUnknownClassLoader()) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeBinary(implementation.getClassLoaderHash().toByteArray());
        }
    }

    private ImmutableSortedMap<String, FileCollectionSnapshot> readSnapshots(Decoder decoder) throws Exception {
        int count = decoder.readSmallInt();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int snapshotIdx = 0; snapshotIdx < count; ++snapshotIdx) {
            String property = decoder.readString();
            FileCollectionSnapshot snapshot = (FileCollectionSnapshot)this.fileCollectionSnapshotSerializer.read(decoder);
            builder.put((Object)property, (Object)snapshot);
        }
        return builder.build();
    }

    private void writeSnapshots(Encoder encoder, Map<String, FileCollectionSnapshot> ids) throws Exception {
        encoder.writeSmallInt(ids.size());
        for (Map.Entry<String, FileCollectionSnapshot> entry : ids.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.fileCollectionSnapshotSerializer.write(encoder, (Object)entry.getValue());
        }
    }
}

