/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.StatefulSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Serializers {
    public static <T> StatefulSerializer<T> stateful(Serializer<T> serializer) {
        return new StatefulSerializerAdapter<T>(serializer);
    }

    public static <T> Serializer<T> constant(final T instance) {
        return new Serializer<T>(){

            @Override
            public T read(Decoder decoder) {
                return instance;
            }

            @Override
            public void write(Encoder encoder, T value) {
                if (value != instance) {
                    throw new IllegalArgumentException("Cannot serialize constant value: " + value);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatefulSerializerAdapter<T>
    implements StatefulSerializer<T> {
        private final Serializer<T> serializer;

        public StatefulSerializerAdapter(Serializer<T> serializer) {
            this.serializer = serializer;
        }

        @Override
        public ObjectReader<T> newReader(final Decoder decoder) {
            return new ObjectReader<T>(){

                @Override
                public T read() throws Exception {
                    return StatefulSerializerAdapter.this.serializer.read(decoder);
                }
            };
        }

        @Override
        public ObjectWriter<T> newWriter(final Encoder encoder) {
            return new ObjectWriter<T>(){

                @Override
                public void write(T value) throws Exception {
                    StatefulSerializerAdapter.this.serializer.write(encoder, value);
                }
            };
        }
    }
}

