/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultBuildOperationQueue<T extends BuildOperation>
implements BuildOperationQueue<T> {
    private final WorkerLeaseService workerLeases;
    private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
    private final Executor executor;
    private final BuildOperationQueue.QueueWorker<T> queueWorker;
    private String logLocation;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition workAvailable = this.lock.newCondition();
    private final Condition operationsComplete = this.lock.newCondition();
    private QueueState queueState = QueueState.Working;
    private int workerCount;
    private int pendingOperations;
    private final Deque<T> workQueue = new LinkedList<T>();
    private final LinkedList<Throwable> failures = new LinkedList();

    DefaultBuildOperationQueue(WorkerLeaseService workerLeases, Executor executor, BuildOperationQueue.QueueWorker<T> queueWorker) {
        this.workerLeases = workerLeases;
        this.parentWorkerLease = workerLeases.getWorkerLease();
        this.executor = executor;
        this.queueWorker = queueWorker;
    }

    @Override
    public void add(T operation) {
        this.lock.lock();
        try {
            if (this.queueState == QueueState.Done) {
                throw new IllegalStateException("BuildOperationQueue cannot be reused once it has completed.");
            }
            if (this.queueState == QueueState.Cancelled) {
                return;
            }
            this.workQueue.add(operation);
            ++this.pendingOperations;
            this.workAvailable.signalAll();
            if (this.workerCount == 0 || this.workerCount < this.workerLeases.getMaxWorkerCount() - 1) {
                this.executor.execute(new WorkerRunnable());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cancel() {
        this.lock.lock();
        try {
            if (this.queueState == QueueState.Cancelled || this.queueState == QueueState.Done) {
                return;
            }
            this.queueState = QueueState.Cancelled;
            this.completeOperations(this.workQueue.size());
            this.workQueue.clear();
            this.workAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void waitForCompletion() throws MultipleBuildOperationFailures {
        this.lock.lock();
        try {
            if (this.queueState == QueueState.Done) {
                throw new IllegalStateException("Cannot wait for completion more than once.");
            }
            this.queueState = QueueState.Finishing;
            this.workAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        try {
            new WorkerRunnable().run();
        }
        catch (Throwable t) {
            this.addFailure(t);
        }
        this.lock.lock();
        try {
            while (this.pendingOperations > 0) {
                try {
                    this.operationsComplete.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            this.queueState = QueueState.Done;
            if (!this.failures.isEmpty()) {
                throw new MultipleBuildOperationFailures(DefaultBuildOperationQueue.getFailureMessage(this.failures), this.failures, this.logLocation);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addFailure(Throwable failure) {
        this.lock.lock();
        try {
            this.failures.add(failure);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void completeOperations(int count) {
        this.lock.lock();
        try {
            this.pendingOperations -= count;
            this.operationsComplete.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    private static String getFailureMessage(Collection<? extends Throwable> failures) {
        if (failures.size() == 1) {
            return "A build operation failed.";
        }
        return "Multiple build operations failed.";
    }

    private class WorkerRunnable
    implements Runnable {
        private WorkerRunnable() {
        }

        @Override
        public void run() {
            Object operation;
            while ((operation = this.waitForNextOperation()) != null) {
                this.runBatch(operation);
            }
            this.shutDown();
        }

        private T waitForNextOperation() {
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                while (DefaultBuildOperationQueue.this.queueState == QueueState.Working && DefaultBuildOperationQueue.this.workQueue.isEmpty()) {
                    try {
                        DefaultBuildOperationQueue.this.workAvailable.await();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                }
                Object t = this.getNextOperation();
                return t;
            }
            finally {
                DefaultBuildOperationQueue.this.lock.unlock();
            }
        }

        private void runBatch(final T firstOperation) {
            DefaultBuildOperationQueue.this.completeOperations(DefaultBuildOperationQueue.this.workerLeases.withLocks(Collections.singleton(DefaultBuildOperationQueue.this.parentWorkerLease.createChild()), new Factory<Integer>(){

                @Override
                public Integer create() {
                    int operationCount = 0;
                    BuildOperation operation = firstOperation;
                    while (operation != null) {
                        WorkerRunnable.this.runOperation(operation);
                        ++operationCount;
                        operation = WorkerRunnable.this.getNextOperation();
                    }
                    return operationCount;
                }
            }));
        }

        private T getNextOperation() {
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                BuildOperation buildOperation = (BuildOperation)DefaultBuildOperationQueue.this.workQueue.pollFirst();
                return buildOperation;
            }
            finally {
                DefaultBuildOperationQueue.this.lock.unlock();
            }
        }

        private void runOperation(T operation) {
            try {
                DefaultBuildOperationQueue.this.queueWorker.execute(operation);
            }
            catch (Throwable t) {
                DefaultBuildOperationQueue.this.addFailure(t);
            }
        }

        private void shutDown() {
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                DefaultBuildOperationQueue.this.workerCount--;
            }
            finally {
                DefaultBuildOperationQueue.this.lock.unlock();
            }
        }
    }

    private static enum QueueState {
        Working,
        Finishing,
        Cancelled,
        Done;

    }
}

