/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.scala.ScalaCompilerFactory;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.scala.tasks.AbstractScalaCompile;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.WorkerDaemonFactory;

@CacheableTask
public class ScalaCompile
extends AbstractScalaCompile {
    private FileCollection scalaClasspath;
    private FileCollection zincClasspath;
    private Compiler<ScalaJavaJointCompileSpec> compiler;

    @Inject
    public ScalaCompile() {
        super((BaseScalaCompileOptions)new ScalaCompileOptions());
    }

    @Nested
    public ScalaCompileOptions getScalaCompileOptions() {
        return (ScalaCompileOptions)super.getScalaCompileOptions();
    }

    @Classpath
    public FileCollection getScalaClasspath() {
        return this.scalaClasspath;
    }

    public void setScalaClasspath(FileCollection scalaClasspath) {
        this.scalaClasspath = scalaClasspath;
    }

    @Classpath
    public FileCollection getZincClasspath() {
        return this.zincClasspath;
    }

    public void setZincClasspath(FileCollection zincClasspath) {
        this.zincClasspath = zincClasspath;
    }

    public void setCompiler(Compiler<ScalaJavaJointCompileSpec> compiler) {
        this.compiler = compiler;
    }

    protected Compiler<ScalaJavaJointCompileSpec> getCompiler(ScalaJavaJointCompileSpec spec) {
        this.assertScalaClasspathIsNonEmpty();
        if (this.compiler == null) {
            WorkerDaemonFactory workerDaemonFactory = (WorkerDaemonFactory)this.getServices().get(WorkerDaemonFactory.class);
            FileResolver fileResolver = (FileResolver)this.getServices().get(FileResolver.class);
            ScalaCompilerFactory scalaCompilerFactory = new ScalaCompilerFactory(((WorkerDirectoryProvider)this.getServices().get(WorkerDirectoryProvider.class)).getWorkingDirectory(), workerDaemonFactory, this.getScalaClasspath(), this.getZincClasspath(), this.getProject().getGradle().getGradleUserHomeDir(), fileResolver);
            this.compiler = scalaCompilerFactory.newCompiler(spec);
        }
        return this.compiler;
    }

    protected void assertScalaClasspathIsNonEmpty() {
        if (this.getScalaClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".scalaClasspath' must not be empty. If a Scala compile dependency is provided, the 'scala-base' plugin will attempt to configure 'scalaClasspath' automatically. Alternatively, you may configure 'scalaClasspath' explicitly.");
        }
    }
}

