/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear.internal;

import groovy.lang.Closure;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.plugins.ear.EarPluginConvention;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultDeploymentDescriptor;
import org.gradle.util.ConfigureUtil;

public class DefaultEarPluginConvention
extends EarPluginConvention
implements HasPublicType {
    private FileResolver fileResolver;
    private ObjectFactory objectFactory;
    private DeploymentDescriptor deploymentDescriptor;
    private String appDirName;
    private String libDirName;

    @Inject
    public DefaultEarPluginConvention(FileResolver fileResolver, ObjectFactory objectFactory) {
        this.fileResolver = fileResolver;
        this.objectFactory = objectFactory;
        this.deploymentDescriptor = (DeploymentDescriptor)objectFactory.newInstance(DefaultDeploymentDescriptor.class, new Object[]{fileResolver, objectFactory});
        this.deploymentDescriptor.readFrom("META-INF/application.xml");
        this.deploymentDescriptor.readFrom(this.appDirName + "/META-INF/" + this.deploymentDescriptor.getFileName());
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(EarPluginConvention.class);
    }

    @Override
    public String getAppDirName() {
        return this.appDirName;
    }

    @Override
    public void setAppDirName(String appDirName) {
        this.appDirName = appDirName;
        if (this.deploymentDescriptor != null) {
            this.deploymentDescriptor.readFrom(new File(appDirName, "META-INF/" + this.deploymentDescriptor.getFileName()));
        }
    }

    @Override
    public void appDirName(String appDirName) {
        this.setAppDirName(appDirName);
    }

    @Override
    public String getLibDirName() {
        return this.libDirName;
    }

    @Override
    public void setLibDirName(String libDirName) {
        this.libDirName = libDirName;
    }

    @Override
    public void libDirName(String libDirName) {
        this.libDirName = libDirName;
    }

    @Override
    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    @Override
    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }

    @Override
    public DefaultEarPluginConvention deploymentDescriptor(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.forceDeploymentDescriptor());
        return this;
    }

    @Override
    public DefaultEarPluginConvention deploymentDescriptor(Action<? super DeploymentDescriptor> configureAction) {
        configureAction.execute((Object)this.forceDeploymentDescriptor());
        return this;
    }

    private DeploymentDescriptor forceDeploymentDescriptor() {
        if (this.deploymentDescriptor == null) {
            this.deploymentDescriptor = (DeploymentDescriptor)this.objectFactory.newInstance(DefaultDeploymentDescriptor.class, new Object[]{this.fileResolver, this.objectFactory});
            assert (this.deploymentDescriptor != null);
        }
        return this.deploymentDescriptor;
    }
}

