/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.GraphValidationException;
import org.gradle.internal.text.TreeFormatter;

public class LockOutOfDateException
extends GraphValidationException {
    private final List<String> errors;

    public static LockOutOfDateException createLockOutOfDateException(String configurationName, Iterable<String> errors) {
        TreeFormatter treeFormatter = new TreeFormatter();
        treeFormatter.node("Dependency lock state for configuration '" + configurationName + "' is out of date");
        treeFormatter.startChildren();
        for (String error : errors) {
            treeFormatter.node(error);
        }
        treeFormatter.endChildren();
        return new LockOutOfDateException(treeFormatter.toString(), (List<String>)ImmutableList.copyOf(errors));
    }

    public LockOutOfDateException(String message) {
        super(message);
        this.errors = Collections.emptyList();
    }

    private LockOutOfDateException(String message, List<String> errors) {
        super(message);
        this.errors = errors;
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

