/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.changedetection.state.AbstractTaskExecution;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

@NonNullApi
public class CurrentTaskExecution
extends AbstractTaskExecution {
    private static final Function<FileCollectionFingerprint, HistoricalFileCollectionFingerprint> ARCHIVE_FINGERPRINT = new Function<FileCollectionFingerprint, HistoricalFileCollectionFingerprint>(){

        public HistoricalFileCollectionFingerprint apply(FileCollectionFingerprint value) {
            return value.archive();
        }
    };
    private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFingerprints;
    private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFingerprints;
    private final OverlappingOutputs detectedOverlappingOutputs;
    private Boolean successful;
    private OriginTaskExecutionMetadata originExecutionMetadata;

    public CurrentTaskExecution(ImplementationSnapshot taskImplementation, ImmutableList<ImplementationSnapshot> taskActionImplementations, ImmutableSortedMap<String, ValueSnapshot> inputProperties, ImmutableSortedSet<String> outputPropertyNames, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFingerprints, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFingerprintsBeforeExecution, @Nullable OverlappingOutputs detectedOverlappingOutputs) {
        super(taskImplementation, taskActionImplementations, inputProperties, outputPropertyNames);
        this.outputFingerprints = outputFingerprintsBeforeExecution;
        this.inputFingerprints = inputFingerprints;
        this.detectedOverlappingOutputs = detectedOverlappingOutputs;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getOutputFingerprints() {
        return this.outputFingerprints;
    }

    public void setOutputFingerprintsAfterExecution(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFilesSnapshot) {
        this.outputFingerprints = outputFilesSnapshot;
    }

    public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFingerprints() {
        return this.inputFingerprints;
    }

    @Nullable
    public OverlappingOutputs getDetectedOverlappingOutputs() {
        return this.detectedOverlappingOutputs;
    }

    public HistoricalTaskExecution archive() {
        ImmutableSortedMap historicalInputFingerprints = ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformValues(this.inputFingerprints, ARCHIVE_FINGERPRINT));
        ImmutableSortedMap historicalOutputFingerprints = ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformValues(this.outputFingerprints, ARCHIVE_FINGERPRINT));
        return new HistoricalTaskExecution(this.getTaskImplementation(), this.getTaskActionImplementations(), this.getInputProperties(), this.getOutputPropertyNamesForCacheKey(), (ImmutableSortedMap<String, HistoricalFileCollectionFingerprint>)historicalInputFingerprints, (ImmutableSortedMap<String, HistoricalFileCollectionFingerprint>)historicalOutputFingerprints, this.successful, this.originExecutionMetadata);
    }

    @Override
    public OriginTaskExecutionMetadata getOriginExecutionMetadata() {
        return this.originExecutionMetadata;
    }

    public void setOriginExecutionMetadata(OriginTaskExecutionMetadata originExecutionMetadata) {
        this.originExecutionMetadata = originExecutionMetadata;
    }
}

