/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionLeafVisitor;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.tasks.AbstractTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.CacheableTaskOutputCompositeFilePropertyElementSpec;
import org.gradle.api.internal.tasks.DeclaredTaskOutputFileProperty;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyFileCollection;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.DeferredUtil;

@NonNullApi
public class CompositeTaskOutputPropertySpec
extends AbstractTaskOutputPropertySpec
implements DeclaredTaskOutputFileProperty {
    private final OutputType outputType;
    private final ValidatingValue value;
    private final ValidationAction validationAction;
    private final String taskDisplayName;
    private final FileResolver resolver;

    public CompositeTaskOutputPropertySpec(String taskDisplayName, FileResolver resolver, OutputType outputType, ValidatingValue value, ValidationAction validationAction) {
        this.taskDisplayName = taskDisplayName;
        this.resolver = resolver;
        this.outputType = outputType;
        this.value = value;
        this.validationAction = validationAction;
    }

    @Override
    public OutputType getOutputType() {
        return this.outputType;
    }

    public Iterator<TaskOutputFilePropertySpec> resolveToOutputProperties() {
        Object unpackedValue = DeferredUtil.unpack((Object)this.value);
        if (unpackedValue == null) {
            return Collections.emptyIterator();
        }
        if (unpackedValue instanceof Map) {
            final Iterator iterator = ((Map)unpackedValue).entrySet().iterator();
            return new AbstractIterator<TaskOutputFilePropertySpec>(){

                protected TaskOutputFilePropertySpec computeNext() {
                    if (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        Object key = entry.getKey();
                        if (key == null) {
                            throw new IllegalArgumentException(String.format("Mapped output property '%s' has null key", CompositeTaskOutputPropertySpec.this.getPropertyName()));
                        }
                        String id = key.toString();
                        File file = CompositeTaskOutputPropertySpec.this.resolver.resolve(entry.getValue());
                        return new CacheableTaskOutputCompositeFilePropertyElementSpec(CompositeTaskOutputPropertySpec.this, "." + id, file);
                    }
                    return (TaskOutputFilePropertySpec)this.endOfData();
                }
            };
        }
        final ArrayList roots = Lists.newArrayList();
        final MutableBoolean nonFileRoot = new MutableBoolean();
        FileCollectionInternal outputFileCollection = this.resolver.resolveFiles(new Object[]{unpackedValue});
        outputFileCollection.visitLeafCollections(new FileCollectionLeafVisitor(){

            public void visitCollection(FileCollectionInternal fileCollection) {
                Iterables.addAll((Collection)roots, (Iterable)fileCollection);
            }

            public void visitGenericFileTree(FileTreeInternal fileTree) {
                nonFileRoot.set(true);
            }

            public void visitDirectoryTree(DirectoryFileTree directoryTree) {
                nonFileRoot.set(true);
            }
        });
        if (nonFileRoot.get()) {
            return Iterators.singletonIterator((Object)this);
        }
        final Iterator iterator = roots.iterator();
        return new AbstractIterator<TaskOutputFilePropertySpec>(){
            private int index;

            protected TaskOutputFilePropertySpec computeNext() {
                if (!iterator.hasNext()) {
                    return (TaskOutputFilePropertySpec)this.endOfData();
                }
                return new CacheableTaskOutputCompositeFilePropertyElementSpec(CompositeTaskOutputPropertySpec.this, "$" + ++this.index, (File)iterator.next());
            }
        };
    }

    @Override
    public void attachProducer(Task producer) {
        this.value.attachProducer(producer);
    }

    @Override
    public void prepareValue() {
        this.value.maybeFinalizeValue();
    }

    @Override
    public void cleanupValue() {
    }

    @Override
    public void validate(TaskValidationContext context) {
        this.value.validate(this.getPropertyName(), this.isOptional(), this.validationAction, context);
    }

    @Override
    public FileCollection getPropertyFiles() {
        return new TaskPropertyFileCollection(this.taskDisplayName, "output", this, (PathToFileResolver)this.resolver, this.value);
    }
}

