/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.GradleApiSpecAggregator;
import org.gradle.initialization.GradleApiSpecProvider;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.initialization.MixInLegacyTypesClassLoader;
import org.gradle.internal.classloader.FilteringClassLoader;

public class DefaultClassLoaderRegistry
implements ClassLoaderRegistry {
    private final ClassLoader apiOnlyClassLoader;
    private final ClassLoader apiAndPluginsClassLoader;
    private final ClassLoader pluginsClassLoader;

    public DefaultClassLoaderRegistry(ClassPathRegistry classPathRegistry, LegacyTypesSupport legacyTypesSupport) {
        ClassLoader runtimeClassLoader = this.getClass().getClassLoader();
        this.apiOnlyClassLoader = this.restrictToGradleApi(runtimeClassLoader);
        this.pluginsClassLoader = new MixInLegacyTypesClassLoader(runtimeClassLoader, classPathRegistry.getClassPath("GRADLE_EXTENSIONS"), legacyTypesSupport);
        this.apiAndPluginsClassLoader = this.restrictToGradleApi(this.pluginsClassLoader);
    }

    private ClassLoader restrictToGradleApi(ClassLoader classLoader) {
        return DefaultClassLoaderRegistry.restrictTo(DefaultClassLoaderRegistry.apiSpecFor(classLoader), classLoader);
    }

    private static ClassLoader restrictTo(FilteringClassLoader.Spec spec, ClassLoader parent) {
        return new FilteringClassLoader(parent, spec);
    }

    private static FilteringClassLoader.Spec apiSpecFor(ClassLoader classLoader) {
        FilteringClassLoader.Spec apiSpec = new FilteringClassLoader.Spec();
        GradleApiSpecProvider.Spec apiAggregate = new GradleApiSpecAggregator(classLoader).aggregate();
        for (String string : apiAggregate.getExportedResources()) {
            apiSpec.allowResource(string);
        }
        for (String string : apiAggregate.getExportedResourcePrefixes()) {
            apiSpec.allowResources(string);
        }
        for (Class clazz : apiAggregate.getExportedClasses()) {
            apiSpec.allowClass(clazz);
        }
        for (String string : apiAggregate.getExportedPackages()) {
            apiSpec.allowPackage(string);
        }
        return apiSpec;
    }

    @Override
    public ClassLoader getRuntimeClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public ClassLoader getGradleApiClassLoader() {
        return this.apiAndPluginsClassLoader;
    }

    @Override
    public ClassLoader getPluginsClassLoader() {
        return this.pluginsClassLoader;
    }

    @Override
    public ClassLoader getGradleCoreApiClassLoader() {
        return this.apiOnlyClassLoader;
    }
}

