/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scan.config;

import org.gradle.internal.scan.config.BuildScanConfig;
import org.gradle.internal.scan.config.UnsupportedBuildScanPluginVersionException;
import org.gradle.util.VersionNumber;

class BuildScanPluginCompatibility {
    public static final VersionNumber MIN_SUPPORTED_VERSION = VersionNumber.parse("2.0.2");
    private static final String MIN_SUPPORTED_VERSION_DISPLAY = "2.0.2";
    public static final String UNSUPPORTED_PLUGIN_VERSION_MESSAGE = "This version of Gradle requires version 2.0.2 of the build scan plugin or later.\nPlease see https://gradle.com/scans/help/gradle-incompatible-plugin-version for more information.";
    public static final String UNSUPPORTED_TOGGLE = "org.gradle.internal.unsupported-scan-plugin";
    public static final String UNSUPPORTED_TOGGLE_MESSAGE = "Build scan support disabled by secret toggle";
    public static final String KOTLIN_SCRIPT_BUILD_CACHE_TOGGLE = "org.gradle.kotlin.dsl.caching.buildcache";

    BuildScanPluginCompatibility() {
    }

    String unsupportedReason(VersionNumber pluginVersion, BuildScanConfig.Attributes attributes) {
        if (BuildScanPluginCompatibility.isEarlierThan(pluginVersion, MIN_SUPPORTED_VERSION)) {
            return UNSUPPORTED_PLUGIN_VERSION_MESSAGE;
        }
        if (Boolean.getBoolean(UNSUPPORTED_TOGGLE)) {
            return UNSUPPORTED_TOGGLE_MESSAGE;
        }
        return null;
    }

    private static boolean isEarlierThan(VersionNumber pluginVersion, VersionNumber minSupportedVersion) {
        return pluginVersion.compareTo(minSupportedVersion) < 0;
    }

    UnsupportedBuildScanPluginVersionException unsupportedVersionException() {
        return new UnsupportedBuildScanPluginVersionException(UNSUPPORTED_PLUGIN_VERSION_MESSAGE);
    }
}

