/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;

public class VisualStudioProjectConfiguration {
    private final DefaultVisualStudioProject vsProject;
    private final String name;
    private final String configurationName;
    private final String platformName = "Win32";
    private final VisualStudioTargetBinary binary;

    public VisualStudioProjectConfiguration(DefaultVisualStudioProject vsProject, String configurationName, VisualStudioTargetBinary binary) {
        this.vsProject = vsProject;
        this.configurationName = configurationName;
        this.name = configurationName + "|" + "Win32";
        this.binary = binary;
    }

    @Input
    public String getName() {
        return this.name;
    }

    @Input
    public String getConfigurationName() {
        return this.configurationName;
    }

    @Input
    public String getPlatformName() {
        return "Win32";
    }

    @Nested
    public VisualStudioTargetBinary getTargetBinary() {
        return this.binary;
    }

    @Internal
    public final String getType() {
        return "Makefile";
    }

    @Internal
    public DefaultVisualStudioProject getProject() {
        return this.vsProject;
    }

    @Input
    public String getBinaryOutputPath() {
        return this.binary.getOutputFile().getAbsolutePath();
    }
}

