/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;

public class InvertedRenderableModuleResult
extends RenderableModuleResult {
    public InvertedRenderableModuleResult(ResolvedComponentResult module) {
        super(module);
    }

    @Override
    public Set<RenderableDependency> getChildren() {
        LinkedHashMap<ComponentIdentifier, InvertedRenderableModuleResult> children = new LinkedHashMap<ComponentIdentifier, InvertedRenderableModuleResult>();
        for (ResolvedDependencyResult dependent : this.module.getDependents()) {
            InvertedRenderableModuleResult child = new InvertedRenderableModuleResult(dependent.getFrom());
            if (children.containsKey(child.getId())) continue;
            children.put(child.getId(), child);
        }
        return new LinkedHashSet<RenderableDependency>(children.values());
    }

    @Override
    public String getName() {
        String base = super.getName();
        for (ComponentSelectionDescriptor descriptor : this.module.getSelectionReason().getDescriptions()) {
            if (descriptor.getCause() != ComponentSelectionCause.CONFLICT_RESOLUTION) continue;
            return base + " (" + descriptor.getCause().getDefaultReason() + " " + descriptor.getDescription() + ")";
        }
        return base;
    }
}

