/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedClassConstructorDescriptor;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.EnumClassTransformer$WhenMappings;
import org.jetbrains.kotlin.ir.backend.js.lower.EnumClassTransformer$findFunctionDescriptorForMemberWithSyntheticBodyKind$;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.IrBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002=>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a\u00a2\u0006\u0002\b\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0002J\b\u0010!\u001a\u00020\"H\u0002J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010$\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0002J\u001e\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\u001cH\u0002J\b\u0010-\u001a\u00020\u001cH\u0002J\b\u0010.\u001a\u00020\u001cH\u0002J\u0016\u0010/\u001a\u00020\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0002J\b\u00100\u001a\u00020\u001cH\u0002J\b\u00101\u001a\u00020\u001cH\u0002J\b\u00102\u001a\u00020\u001cH\u0002J\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\fJ\u0018\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0005H\u0002J\u0012\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f09*\u00020\rH\u0002J\u0012\u0010:\u001a\b\u0012\u0004\u0012\u00020;09*\u00020\rH\u0002J\f\u0010<\u001a\u00020\u0018*\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassTransformer;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "enumEntries", "", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "enumName", "", "loweredEnumConstructors", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "name", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "bodyBuilder", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "", "Lkotlin/ExtensionFunctionType;", "createEntryInstancesInitializedVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "createEnumEntryInstanceVariables", "createEnumValueOfBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "createGetEntryInstanceFuns", "initEntryInstancesFun", "entryInstances", "createInitEntryInstancesFun", "entryInstancesInitializedVar", "findFunctionDescriptorForMemberWithSyntheticBodyKind", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "kind", "Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBodyKind;", "fixReferencesToConstructorParameters", "lowerEnumConstructorsBody", "lowerEnumConstructorsSignature", "lowerEnumEntryClassConstructors", "lowerEnumEntryInitializerExpression", "lowerSyntheticFunctions", "replaceIrEntriesWithCorrespondingClasses", "transform", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "transformEnumConstructor", "enumConstructor", "enumClass", "getNameExpression", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "getOrdinalExpression", "", "getType", "IrEnumClassConstructorTransformer", "IrEnumEntryClassConstructorTransformer", "backend.js"})
public final class EnumClassTransformer {
    private final DeclarationIrBuilder builder;
    private final List<IrEnumEntry> enumEntries;
    private final HashMap<IrConstructorSymbol, IrConstructor> loweredEnumConstructors;
    private final String enumName;
    @NotNull
    private final JsIrBackendContext context;
    private final IrClass irClass;

    @NotNull
    public final List<IrDeclaration> transform() {
        this.lowerEnumConstructorsSignature();
        this.lowerEnumConstructorsBody();
        this.fixReferencesToConstructorParameters();
        List<IrVariable> entryInstances = this.createEnumEntryInstanceVariables();
        this.lowerEnumEntryClassConstructors(entryInstances);
        this.lowerEnumEntryInitializerExpression();
        IrVariable entryInstancesInitializedVar = this.createEntryInstancesInitializedVar();
        IrSimpleFunction initEntryInstancesFun = this.createInitEntryInstancesFun(entryInstancesInitializedVar, entryInstances);
        List<IrSimpleFunction> entryGetInstanceFuns = this.createGetEntryInstanceFuns(initEntryInstancesFun, entryInstances);
        this.lowerSyntheticFunctions();
        this.replaceIrEntriesWithCorrespondingClasses();
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.irClass), (Iterable)entryInstances), (Iterable)CollectionsKt.listOf((Object[])new IrSymbolDeclaration[]{entryInstancesInitializedVar, initEntryInstancesFun})), (Iterable)entryGetInstanceFuns);
    }

    private final void fixReferencesToConstructorParameters() {
        Map $receiver$iv;
        Map fromOldToNewParameter = new LinkedHashMap();
        Map map2 = $receiver$iv = (Map)this.loweredEnumConstructors;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $oldCtorSymbol_newCtor;
            Map.Entry entry = $oldCtorSymbol_newCtor = (element$iv = iterator2.next());
            IrConstructorSymbol oldCtorSymbol = (IrConstructorSymbol)entry.getKey();
            entry = $oldCtorSymbol_newCtor;
            IrConstructor newCtor = (IrConstructor)entry.getValue();
            List<IrValueParameter> oldParameters = ((IrConstructor)oldCtorSymbol.getOwner()).getValueParameters();
            List<IrValueParameter> newParameters = newCtor.getValueParameters();
            Iterable $receiver$iv2 = oldParameters;
            for (Object element$iv2 : $receiver$iv2) {
                IrValueParameter old = (IrValueParameter)element$iv2;
                Map map3 = fromOldToNewParameter;
                Object s = old.getSymbol();
                Iterable $receiver$iv3 = newParameters;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv3 : $receiver$iv3) {
                    IrValueParameter it = (IrValueParameter)element$iv3;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)old.getName())) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv3;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object v2 = single$iv;
                map3.put(s, v2);
            }
        }
        IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new IrElementTransformerVoid(this, fromOldToNewParameter){
            final /* synthetic */ EnumClassTransformer this$0;
            final /* synthetic */ Map $fromOldToNewParameter;

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Object object = this.$fromOldToNewParameter;
                IrValueSymbol irValueSymbol = expression2.getSymbol();
                IrValueParameter irValueParameter = (IrValueParameter)object.get(irValueSymbol);
                if (irValueParameter != null) {
                    Object it = object = irValueParameter;
                    return ExpressionHelpersKt.irGet(EnumClassTransformer.access$getBuilder$p(this.this$0), (IrValueDeclaration)it);
                }
                return super.visitGetValue(expression2);
            }
            {
                this.this$0 = $outer;
                this.$fromOldToNewParameter = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final IrBody createEnumValueOfBody() {
        Collection<IrBranchImpl> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        void this_$iv$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrFunction valueOfFun = this.findFunctionDescriptorForMemberWithSyntheticBodyKind(IrSyntheticBodyKind.ENUM_VALUEOF);
        IrValueParameter nameParameter = valueOfFun.getValueParameters().get(0);
        Map<IrEnumEntrySymbol, IrSimpleFunctionSymbol> entryInstanceToFunction = this.context.getEnumEntryToGetInstanceFunction();
        DeclarationIrBuilder $receiver = declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.context, valueOfFun.getSymbol(), 0, 0, 6, null);
        IrGeneratorWithScope $receiver$iv2 = $receiver;
        int startOffset$iv = -1;
        int endOffset$iv = -1;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($receiver$iv2.getContext(), $receiver$iv2.getScope(), startOffset$iv, endOffset$iv);
        void $receiver2 = this_$iv$iv;
        Iterable iterable = this.enumEntries;
        IrType irType = IrUtilsKt.getDefaultType(this.irClass);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$receiver2;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$receiver2;
        void var15_15 = $receiver2;
        void var16_16 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            IrSimpleFunctionSymbol getInstance2;
            void it;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            collection = destination$iv$iv;
            if (entryInstanceToFunction.get(it.getSymbol()) == null) {
                Intrinsics.throwNpe();
            }
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$receiver2;
            IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$receiver2;
            IrBuilderWithScope irBuilderWithScope5 = (IrBuilderWithScope)$receiver2;
            String string = it.getName().getIdentifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name.identifier");
            IrBranchImpl irBranchImpl = ExpressionHelpersKt.irBranch(irBuilderWithScope3, ExpressionHelpersKt.irEquals$default(irBuilderWithScope4, ExpressionHelpersKt.irString(irBuilderWithScope5, string), ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver2, nameParameter), null, 4, null), ExpressionHelpersKt.irCall((IrBuilderWithScope)$receiver2, getInstance2));
            collection.add(irBranchImpl);
        }
        collection = (List)destination$iv$iv;
        var15_15.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope2, ExpressionHelpersKt.irWhen(irBuilderWithScope, irType, CollectionsKt.plus((Collection)collection, (Object)ExpressionHelpersKt.irElseBranch((IrBuilderWithScope)$receiver2, ExpressionHelpersKt.irCall((IrBuilderWithScope)$receiver2, $receiver2.getContext().getIrBuiltIns().getThrowIseSymbol()))))));
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final void lowerEnumConstructorsSignature() {
        List<IrDeclaration> $receiver$iv = this.irClass.getDeclarations();
        Iterable $receiver$iv$iv = $receiver$iv;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void declaration;
            IrElement irElement;
            void item$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            IrElement irElement2 = (IrElement)item$iv$iv;
            int i$iv = n2;
            IrDeclaration irDeclaration = (IrDeclaration)item$iv;
            int n3 = i$iv;
            List<IrDeclaration> list2 = $receiver$iv;
            IrElement irElement3 = irElement = (IrElement)(declaration instanceof IrConstructor ? (IrDeclaration)this.transformEnumConstructor((IrConstructor)declaration, this.irClass) : declaration);
            if (irElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            }
            list2.set(n3, (IrDeclaration)irElement3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void lowerEnumConstructorsBody() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.irClass.getDeclarations();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof IrConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            IrConstructor it = (IrConstructor)element$iv;
            new IrEnumClassConstructorTransformer(it).transformBody();
        }
    }

    private final void lowerEnumEntryClassConstructors(List<? extends IrVariable> entryInstances) {
        for (Pair pair : CollectionsKt.zip((Iterable)this.enumEntries, (Iterable)entryInstances)) {
            IrEnumEntry entry = (IrEnumEntry)pair.component1();
            IrVariable instance = (IrVariable)pair.component2();
            Sequence<IrConstructor> sequence2 = entry.getCorrespondingClass();
            if (sequence2 == null || (sequence2 = IrUtilsKt.getConstructors((IrClass)sequence2)) == null) continue;
            Sequence<IrConstructor> $receiver$iv = sequence2;
            for (Object element$iv : $receiver$iv) {
                IrBlockBody irBlockBody2;
                IrConstructor it = (IrConstructor)element$iv;
                IrElementTransformerVoidKt.transformChildrenVoid(it, new IrEnumEntryClassConstructorTransformer(entry, true));
                IrBody irBody = it.getBody();
                if (!(irBody instanceof IrBlockBody)) {
                    irBody = null;
                }
                if ((IrBlockBody)irBody == null) continue;
                IrBlockBody $receiver = irBlockBody2;
                DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.context, it.getSymbol(), 0, 0, 6, null);
                int n = 0;
                List<IrStatement> list2 = $receiver.getStatements();
                DeclarationIrBuilder $receiver2 = declarationIrBuilder;
                IrBuilderWithScope irBuilderWithScope = $receiver2;
                IrVariableSymbol irVariableSymbol = (IrVariableSymbol)instance.getSymbol();
                IrBuilderWithScope irBuilderWithScope2 = $receiver2;
                IrClass irClass = entry.getCorrespondingClass();
                if (irClass == null) {
                    Intrinsics.throwNpe();
                }
                IrValueParameter irValueParameter = irClass.getThisReceiver();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
                IrSetVariableImpl irSetVariableImpl = ExpressionHelpersKt.irSetVar(irBuilderWithScope, irVariableSymbol, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter));
                list2.add(n, irSetVariableImpl);
            }
        }
    }

    private final void lowerEnumEntryInitializerExpression() {
        for (IrEnumEntry entry : this.enumEntries) {
            IrExpression irExpression = entry.getInitializerExpression();
            entry.setInitializerExpression(irExpression != null ? irExpression.transform(new IrEnumEntryClassConstructorTransformer(entry, false), null) : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrVariable> createEnumEntryInstanceVariables() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.enumEntries;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            DeclarationIrBuilder declarationIrBuilder;
            void enumEntry;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            IrType type2 = IrTypesKt.makeNullable(this.getType((IrEnumEntry)enumEntry));
            String name = this.enumName + '_' + enumEntry.getName().getIdentifier() + "_instance";
            DeclarationIrBuilder $receiver = declarationIrBuilder = this.builder;
            IrVariable irVariable = Scope.createTemporaryVariable$default($receiver.getScope(), ExpressionHelpersKt.irImplicitCast($receiver, ExpressionHelpersKt.irNull($receiver), type2), name, false, null, null, 28, null);
            collection.add(irVariable);
        }
        return (List)var3_3;
    }

    private final void replaceIrEntriesWithCorrespondingClasses() {
        List<IrDeclaration> $receiver$iv = this.irClass.getDeclarations();
        int i$iv = 0;
        while (i$iv < $receiver$iv.size()) {
            IrDeclaration item$iv = $receiver$iv.get(i$iv);
            IrDeclaration it = item$iv;
            List transformed$iv = CollectionsKt.listOfNotNull((Object)(it instanceof IrEnumEntry ? (IrDeclaration)((IrEnumEntry)it).getCorrespondingClass() : it));
            if (transformed$iv == null) {
                ++i$iv;
                continue;
            }
            $receiver$iv.addAll(i$iv, transformed$iv);
            $receiver$iv.remove(i$iv += transformed$iv.size());
        }
    }

    private final void lowerSyntheticFunctions() {
        IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new IrElementTransformerVoid(this){
            final /* synthetic */ EnumClassTransformer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body) {
                IrBody irBody;
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                switch (EnumClassTransformer$WhenMappings.$EnumSwitchMapping$0[body.getKind().ordinal()]) {
                    case 1: {
                        void this_$iv$iv;
                        IrGeneratorWithScope $receiver$iv = EnumClassTransformer.access$getBuilder$p(this.this$0);
                        int startOffset$iv = -1;
                        int endOffset$iv = -1;
                        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($receiver$iv.getContext(), $receiver$iv.getScope(), startOffset$iv, endOffset$iv);
                        void $receiver = this_$iv$iv;
                        irBody = this_$iv$iv.doBuild();
                        break;
                    }
                    case 2: {
                        irBody = EnumClassTransformer.access$createEnumValueOfBody(this.this$0);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return irBody;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrSimpleFunction> createGetEntryInstanceFuns(IrSimpleFunction initEntryInstancesFun, List<? extends IrVariable> entryInstances) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.enumEntries;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void index2;
            void enumEntry;
            IrSimpleFunction irSimpleFunction;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            IrSimpleFunction $receiver = irSimpleFunction = this.buildFunction(this.enumName + '_' + enumEntry.getName().getIdentifier() + "_getInstance", this.getType((IrEnumEntry)enumEntry), (Function1<? super IrBlockBodyBuilder, Unit>)((Function1)new Function1<IrBlockBodyBuilder, Unit>((int)index2, this, initEntryInstancesFun, entryInstances){
                final /* synthetic */ int $index;
                final /* synthetic */ EnumClassTransformer this$0;
                final /* synthetic */ IrSimpleFunction $initEntryInstancesFun$inlined;
                final /* synthetic */ List $entryInstances$inlined;
                {
                    this.$index = n;
                    this.this$0 = enumClassTransformer;
                    this.$initEntryInstancesFun$inlined = irSimpleFunction;
                    this.$entryInstances$inlined = list2;
                    super(1);
                }

                public final void invoke(@NotNull IrBlockBodyBuilder $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    $receiver.unaryPlus(ExpressionHelpersKt.irCall((IrBuilderWithScope)$receiver, this.$initEntryInstancesFun$inlined));
                    $receiver.unaryPlus(ExpressionHelpersKt.irReturn($receiver, ExpressionHelpersKt.irGet($receiver, (IrValueDeclaration)this.$entryInstances$inlined.get(this.$index))));
                }
            }));
            Map<IrEnumEntrySymbol, IrSimpleFunctionSymbol> map2 = this.context.getEnumEntryToGetInstanceFunction();
            Object s = enumEntry.getSymbol();
            IrFunctionSymbol irFunctionSymbol = $receiver.getSymbol();
            map2.put((IrEnumEntrySymbol)s, (IrSimpleFunctionSymbol)irFunctionSymbol);
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            collection2.add(irSimpleFunction2);
        }
        return (List)destination$iv$iv;
    }

    private final IrSimpleFunction createInitEntryInstancesFun(IrVariable entryInstancesInitializedVar, List<? extends IrVariable> entryInstances) {
        return EnumClassTransformer.buildFunction$default(this, this.enumName + "_initEntries", null, (Function1)new Function1<IrBlockBodyBuilder, Unit>(this, entryInstancesInitializedVar, entryInstances){
            final /* synthetic */ EnumClassTransformer this$0;
            final /* synthetic */ IrVariable $entryInstancesInitializedVar;
            final /* synthetic */ List $entryInstances;

            public final void invoke(@NotNull IrBlockBodyBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.unaryPlus(LowerUtilsKt.irIfThen($receiver, ExpressionHelpersKt.irGet($receiver, this.$entryInstancesInitializedVar), ExpressionHelpersKt.irReturnUnit($receiver)));
                $receiver.unaryPlus(ExpressionHelpersKt.irSetVar($receiver, (IrVariableSymbol)this.$entryInstancesInitializedVar.getSymbol(), ExpressionHelpersKt.irBoolean($receiver, true)));
                for (Pair pair : CollectionsKt.zip((Iterable)EnumClassTransformer.access$getEnumEntries$p(this.this$0), (Iterable)this.$entryInstances)) {
                    IrEnumEntry entry = (IrEnumEntry)pair.component1();
                    IrVariable instanceVar = (IrVariable)pair.component2();
                    IrBuilderWithScope irBuilderWithScope = $receiver;
                    IrVariableSymbol irVariableSymbol = (IrVariableSymbol)instanceVar.getSymbol();
                    IrExpression irExpression = entry.getInitializerExpression();
                    if (irExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    $receiver.unaryPlus(ExpressionHelpersKt.irSetVar(irBuilderWithScope, irVariableSymbol, irExpression));
                }
            }
            {
                this.this$0 = enumClassTransformer;
                this.$entryInstancesInitializedVar = irVariable;
                this.$entryInstances = list2;
                super(1);
            }
        }, 2, null);
    }

    private final IrVariable createEntryInstancesInitializedVar() {
        return Scope.createTemporaryVariable$default(this.builder.getScope(), ExpressionHelpersKt.irBoolean(this.builder, false), this.enumName + "_entriesInitialized", false, null, null, 28, null);
    }

    private final IrConstructor transformEnumConstructor(IrConstructor enumConstructor, IrClass enumClass2) {
        IrConstructorImpl irConstructorImpl;
        WrappedClassConstructorDescriptor loweredConstructorDescriptor = new WrappedClassConstructorDescriptor(null, null, 3, null);
        IrConstructorSymbolImpl loweredConstructorSymbol = new IrConstructorSymbolImpl(loweredConstructorDescriptor);
        IrConstructorImpl $receiver = irConstructorImpl = new IrConstructorImpl(enumConstructor.getStartOffset(), enumConstructor.getEndOffset(), enumConstructor.getOrigin(), loweredConstructorSymbol, enumConstructor.getName(), enumConstructor.getVisibility(), enumConstructor.isInline(), enumConstructor.isExternal(), enumConstructor.isPrimary());
        loweredConstructorDescriptor.bind((IrDeclaration)$receiver);
        $receiver.setParent(enumClass2);
        $receiver.setReturnType(enumConstructor.getReturnType());
        Object object = $receiver.getValueParameters();
        Object object2 = JsIrBuilder.INSTANCE.buildValueParameter("name", 0, this.context.getIrBuiltIns().getStringType());
        IrValueParameter it = object2;
        it.setParent($receiver);
        object.add(object2);
        object = $receiver.getValueParameters();
        object2 = JsIrBuilder.INSTANCE.buildValueParameter("ordinal", 1, this.context.getIrBuiltIns().getIntType());
        it = object2;
        it.setParent($receiver);
        object.add(object2);
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom($receiver, enumConstructor);
        $receiver.setBody(enumConstructor.getBody());
        object = this.loweredEnumConstructors;
        object2 = enumConstructor.getSymbol();
        IrConstructorImpl irConstructorImpl2 = $receiver;
        object.put(object2, irConstructorImpl2);
        return irConstructorImpl;
    }

    private final IrFunction findFunctionDescriptorForMemberWithSyntheticBodyKind(IrSyntheticBodyKind kind) {
        Object element$iv2;
        block2: {
            Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)this.irClass.getDeclarations());
            Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)findFunctionDescriptorForMemberWithSyntheticBodyKind$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            $receiver$iv = sequence2;
            for (Object element$iv2 : $receiver$iv) {
                IrFunction it = (IrFunction)element$iv2;
                IrBody irBody = it.getBody();
                IrBody body = irBody;
                boolean bl = body instanceof IrSyntheticBody && ((IrSyntheticBody)body).getKind() == kind;
                if (!bl) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (IrFunction)element$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction buildFunction(String name, IrType returnType2, Function1<? super IrBlockBodyBuilder, Unit> bodyBuilder) {
        void this_$iv$iv$iv;
        void body$iv;
        void startOffset$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction it = irSimpleFunction = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, name, null, null, false, false, false, false, null, 254, null);
        it.setReturnType(returnType2);
        it.setParent(this.irClass);
        IrGeneratorWithScope irGeneratorWithScope = LowerUtilsKt.createIrBuilder$default(this.context, it.getSymbol(), 0, 0, 6, null);
        Function1<? super IrBlockBodyBuilder, Unit> function1 = bodyBuilder;
        IrSimpleFunction irSimpleFunction2 = it;
        void var9_9 = $receiver$iv;
        int n = ((IrElement)it).getStartOffset();
        int endOffset$iv$iv = ((IrElement)it).getEndOffset();
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($receiver$iv$iv.getContext(), $receiver$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        body$iv.invoke((Object)this_$iv$iv$iv);
        IrBlockBody irBlockBody2 = this_$iv$iv$iv.doBuild();
        irSimpleFunction2.setBody(irBlockBody2);
        return irSimpleFunction;
    }

    static /* synthetic */ IrSimpleFunction buildFunction$default(EnumClassTransformer enumClassTransformer, String string, IrType irType, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            irType = enumClassTransformer.context.getIrBuiltIns().getUnitType();
        }
        return enumClassTransformer.buildFunction(string, irType, (Function1<? super IrBlockBodyBuilder, Unit>)function1);
    }

    private final IrConstImpl<String> getNameExpression(@NotNull IrEnumEntry $receiver) {
        IrBuilderWithScope irBuilderWithScope = this.builder;
        String string = $receiver.getName().getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.name.identifier");
        return ExpressionHelpersKt.irString(irBuilderWithScope, string);
    }

    private final IrConstImpl<Integer> getOrdinalExpression(@NotNull IrEnumEntry $receiver) {
        return ExpressionHelpersKt.irInt(this.builder, this.enumEntries.indexOf($receiver));
    }

    private final IrType getType(@NotNull IrEnumEntry $receiver) {
        IrClass irClass = $receiver.getCorrespondingClass();
        if (irClass == null) {
            irClass = this.irClass;
        }
        return IrUtilsKt.getDefaultType(irClass);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public EnumClassTransformer(@NotNull JsIrBackendContext context, @NotNull IrClass irClass) {
        List list2;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        this.context = context;
        this.irClass = irClass;
        this.builder = LowerUtilsKt.createIrBuilder$default(this.context, this.irClass.getSymbol(), 0, 0, 6, null);
        Iterable iterable = this.irClass.getDeclarations();
        EnumClassTransformer enumClassTransformer = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        enumClassTransformer.enumEntries = list2 = (List)destination$iv$iv;
        this.loweredEnumConstructors = new HashMap();
        String string = this.irClass.getName().getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"irClass.name.identifier");
        this.enumName = string;
    }

    @NotNull
    public static final /* synthetic */ IrBody access$createEnumValueOfBody(EnumClassTransformer $this) {
        return $this.createEnumValueOfBody();
    }

    @NotNull
    public static final /* synthetic */ List access$getEnumEntries$p(EnumClassTransformer $this) {
        return $this.enumEntries;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassTransformer$IrEnumClassConstructorTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)V", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getBuilder", "()Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "transformBody", "", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend.js"})
    private final class IrEnumClassConstructorTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final DeclarationIrBuilder builder;
        @NotNull
        private final IrConstructor constructor;

        @NotNull
        public final DeclarationIrBuilder getBuilder() {
            return this.builder;
        }

        public final void transformBody() {
            block0: {
                IrBody irBody = this.constructor.getBody();
                if (irBody == null) break block0;
                IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrDelegatingConstructorCall visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrDelegatingConstructorCall $receiver = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall(this.builder, (IrConstructor)expression2.getSymbol().getOwner());
            boolean bl = false;
            boolean bl2 = true;
            while (bl <= bl2) {
                void i;
                $receiver.putValueArgument((int)i, ExpressionHelpersKt.irGet(this.builder, this.constructor.getValueParameters().get((int)i)));
                ++i;
            }
            return irDelegatingConstructorCall;
        }

        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            int i;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
            Object object = EnumClassTransformer.this.loweredEnumConstructors;
            IrFunctionSymbol irFunctionSymbol = constructor.getSymbol();
            Map map2 = object;
            boolean constructorWasTransformed = map2.containsKey(irFunctionSymbol);
            if (constructorWasTransformed) {
                Object v2 = EnumClassTransformer.this.loweredEnumConstructors.get(constructor.getSymbol());
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                constructor = (IrConstructor)v2;
            }
            Object $receiver = object = ExpressionHelpersKt.irDelegatingConstructorCall(this.builder, constructor);
            int valueArgIdx = 0;
            int n = 0;
            int n2 = 1;
            while (n <= n2) {
                $receiver.putValueArgument(valueArgIdx++, ExpressionHelpersKt.irGet(this.builder, constructor.getValueParameters().get(i)));
                ++i;
            }
            n2 = expression2.getValueArgumentsCount();
            for (i = 0; i < n2; ++i) {
                $receiver.putValueArgument(valueArgIdx++, expression2.getValueArgument(i));
            }
            return (IrExpression)object;
        }

        @NotNull
        public final IrConstructor getConstructor() {
            return this.constructor;
        }

        public IrEnumClassConstructorTransformer(@NotNull IrConstructor constructor) {
            Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
            this.constructor = constructor;
            this.builder = LowerUtilsKt.createIrBuilder$default(EnumClassTransformer.this.getContext(), this.constructor.getSymbol(), 0, 0, 6, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassTransformer$IrEnumEntryClassConstructorTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "entry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "isInsideConstructor", "", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;Z)V", "getEntry", "()Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "()Z", "buildConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend.js"})
    private final class IrEnumEntryClassConstructorTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrEnumEntry entry;
        private final boolean isInsideConstructor;

        private final IrFunctionAccessExpression buildConstructorCall(IrConstructor constructor) {
            return this.isInsideConstructor ? (IrFunctionAccessExpression)ExpressionHelpersKt.irDelegatingConstructorCall(EnumClassTransformer.this.builder, constructor) : (IrFunctionAccessExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)EnumClassTransformer.this.builder, constructor);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
            Object object = EnumClassTransformer.this.loweredEnumConstructors;
            IrFunctionSymbol irFunctionSymbol = constructor.getSymbol();
            Map map2 = object;
            boolean constructorWasTransformed = map2.containsKey(irFunctionSymbol);
            if (constructorWasTransformed) {
                Object v2 = EnumClassTransformer.this.loweredEnumConstructors.get(constructor.getSymbol());
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                constructor = (IrConstructor)v2;
            }
            Object $receiver = object = this.buildConstructorCall(constructor);
            int valueArgIdx = 0;
            if (constructorWasTransformed) {
                $receiver.putValueArgument(valueArgIdx++, EnumClassTransformer.this.getNameExpression(this.entry));
                $receiver.putValueArgument(valueArgIdx++, EnumClassTransformer.this.getOrdinalExpression(this.entry));
            }
            int n = 0;
            int n2 = expression2.getValueArgumentsCount();
            while (n < n2) {
                void i;
                $receiver.putValueArgument(valueArgIdx++, expression2.getValueArgument((int)i));
                ++i;
            }
            return (IrExpression)object;
        }

        @NotNull
        public final IrEnumEntry getEntry() {
            return this.entry;
        }

        public final boolean isInsideConstructor() {
            return this.isInsideConstructor;
        }

        public IrEnumEntryClassConstructorTransformer(@NotNull IrEnumEntry entry, boolean isInsideConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            this.entry = entry;
            this.isInsideConstructor = isInsideConstructor;
        }
    }
}

