/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.StatefulIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.TaskFingerprintUtil;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.tasks.TaskCacheKeyCalculator;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.change.Change;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.execution.history.changes.DefaultExecutionStateChanges;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.reflect.Instantiator;

@NonNullApi
public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
    private final TaskHistoryRepository taskHistoryRepository;
    private final Instantiator instantiator;
    private final OutputFilesRepository outputFilesRepository;
    private final TaskCacheKeyCalculator taskCacheKeyCalculator;

    public DefaultTaskArtifactStateRepository(FileCollectionFingerprinterRegistry fingerprinterRegistry, TaskHistoryRepository taskHistoryRepository, Instantiator instantiator, OutputFilesRepository outputFilesRepository, TaskCacheKeyCalculator taskCacheKeyCalculator) {
        this.fingerprinterRegistry = fingerprinterRegistry;
        this.taskHistoryRepository = taskHistoryRepository;
        this.instantiator = instantiator;
        this.outputFilesRepository = outputFilesRepository;
        this.taskCacheKeyCalculator = taskCacheKeyCalculator;
    }

    @Override
    public TaskArtifactState getStateFor(TaskInternal task, TaskProperties taskProperties) {
        return new TaskArtifactStateImpl(task, this.taskHistoryRepository.getHistory(task, taskProperties));
    }

    private class TaskArtifactStateImpl
    implements TaskArtifactState {
        private final TaskInternal task;
        private final TaskHistoryRepository.History history;
        private boolean outputsRemoved;
        private boolean statesCalculated;
        private ExecutionStateChanges states;

        public TaskArtifactStateImpl(TaskInternal task, TaskHistoryRepository.History history) {
            this.task = task;
            this.history = history;
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            return this.getExecutionStateChanges().map(new Function<ExecutionStateChanges, StatefulIncrementalTaskInputs>(){

                @Override
                public StatefulIncrementalTaskInputs apply(ExecutionStateChanges changes) {
                    return changes.isRebuildRequired() ? TaskArtifactStateImpl.this.createRebuildInputs() : TaskArtifactStateImpl.this.createIncrementalInputs(changes.getInputFilesChanges());
                }
            }).orElseGet(new Supplier<StatefulIncrementalTaskInputs>(){

                @Override
                public StatefulIncrementalTaskInputs get() {
                    return TaskArtifactStateImpl.this.createRebuildInputs();
                }
            });
        }

        private ChangesOnlyIncrementalTaskInputs createIncrementalInputs(Iterable<Change> inputFilesChanges) {
            return (ChangesOnlyIncrementalTaskInputs)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, new Object[]{inputFilesChanges});
        }

        private RebuildIncrementalTaskInputs createRebuildInputs() {
            return (RebuildIncrementalTaskInputs)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task, this.getCurrentInputFileFingerprints()});
        }

        @Override
        public Iterable<? extends FileCollectionFingerprint> getCurrentInputFileFingerprints() {
            return this.history.getBeforeExecutionState().getInputFileProperties().values();
        }

        @Override
        public boolean isAllowedToUseCachedResults() {
            return true;
        }

        @Override
        @Nullable
        public OverlappingOutputs getOverlappingOutputs() {
            BeforeExecutionState beforeExecutionState = this.history.getBeforeExecutionState();
            AfterPreviousExecutionState afterPreviousExecutionState = this.history.getAfterPreviousExecutionState();
            return OverlappingOutputs.detect((ImmutableSortedMap<String, FileCollectionFingerprint>)(afterPreviousExecutionState == null ? null : afterPreviousExecutionState.getOutputFileProperties()), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)beforeExecutionState.getOutputFileProperties());
        }

        @Override
        public TaskOutputCachingBuildCacheKey calculateCacheKey(TaskProperties taskProperties) {
            return DefaultTaskArtifactStateRepository.this.taskCacheKeyCalculator.calculate(this.task, this.history.getBeforeExecutionState(), taskProperties);
        }

        @Override
        public Map<String, CurrentFileCollectionFingerprint> getOutputFingerprints() {
            return this.history.getBeforeExecutionState().getOutputFileProperties();
        }

        @Override
        public void ensureSnapshotBeforeTask() {
            this.history.getBeforeExecutionState();
        }

        @Override
        public void afterOutputsRemovedBeforeTask() {
            this.outputsRemoved = true;
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterTaskExecution(TaskExecutionContext taskExecutionContext) {
            AfterPreviousExecutionState afterPreviousExecutionState = this.history.getAfterPreviousExecutionState();
            BeforeExecutionState beforeExecutionState = this.history.getBeforeExecutionState();
            return TaskFingerprintUtil.fingerprintAfterOutputsGenerated((ImmutableSortedMap<String, FileCollectionFingerprint>)(afterPreviousExecutionState == null ? null : afterPreviousExecutionState.getOutputFileProperties()), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)beforeExecutionState.getOutputFileProperties(), taskExecutionContext.getTaskProperties().getOutputFileProperties(), this.getOverlappingOutputs() != null, this.task, DefaultTaskArtifactStateRepository.this.fingerprinterRegistry);
        }

        @Override
        public void persistNewOutputs(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputFingerprints, boolean successful, OriginMetadata originMetadata) {
            AfterPreviousExecutionState afterPreviousExecutionState = this.history.getAfterPreviousExecutionState();
            if (successful || afterPreviousExecutionState == null || this.hasAnyOutputFileChanges((ImmutableSortedMap<String, FileCollectionFingerprint>)afterPreviousExecutionState.getOutputFileProperties(), newOutputFingerprints)) {
                this.history.persist(newOutputFingerprints, successful, originMetadata);
                DefaultTaskArtifactStateRepository.this.outputFilesRepository.recordOutputs((Iterable)newOutputFingerprints.values());
            }
        }

        private boolean hasAnyOutputFileChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            return !previous.keySet().equals((Object)current.keySet()) || new OutputFileChanges(previous, current).hasAnyChanges();
        }

        @Override
        public Optional<ExecutionStateChanges> getExecutionStateChanges() {
            if (!this.statesCalculated) {
                this.statesCalculated = true;
                AfterPreviousExecutionState afterPreviousExecutionState = this.history.getAfterPreviousExecutionState();
                BeforeExecutionState beforeExecutionState = this.history.getBeforeExecutionState();
                this.states = afterPreviousExecutionState == null || this.outputsRemoved ? null : new DefaultExecutionStateChanges(afterPreviousExecutionState, beforeExecutionState, new Describable(){

                    public String getDisplayName() {
                        return TaskArtifactStateImpl.this.task.toString();
                    }
                });
            }
            return Optional.ofNullable(this.states);
        }
    }
}

