/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.RefValueHashMap;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

public class ConcurrentWeakKeySoftValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<KeyReference<K, V>, ValueReference<K, V>> myMap;
    final ReferenceQueue<K> myKeyQueue;
    final ReferenceQueue<V> myValueQueue;
    @NotNull
    final TObjectHashingStrategy<? super K> myHashingStrategy;
    private static final ThreadLocal<HardKey> HARD_KEY = new ThreadLocal<HardKey>(){

        @Override
        protected HardKey initialValue() {
            return new HardKey();
        }
    };

    protected ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(0);
        }
        this.myKeyQueue = new ReferenceQueue();
        this.myValueQueue = new ReferenceQueue();
        this.myHashingStrategy = hashingStrategy;
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v2) {
        if (k == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(1);
        }
        if (v2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(2);
        }
        ValueReference<K, V> valueReference = this.createValueReference(v2, this.myValueQueue);
        WeakKey keyReference = new WeakKey(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof SoftValue) {
            ((SoftValue)valueReference).myKeyReference = keyReference;
        }
        WeakKey weakKey = keyReference;
        if (weakKey == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(3);
        }
        return weakKey;
    }

    @NotNull
    protected ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
        if (value == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(4);
        }
        if (queue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(5);
        }
        SoftValue softValue = new SoftValue(value, queue);
        if (softValue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(6);
        }
        return softValue;
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public void clear() {
        this.processQueues();
        this.myMap.clear();
    }

    @NotNull
    private HardKey<K, V> createHardKey(Object o) {
        Object key = o;
        HardKey hardKey = HARD_KEY.get();
        hardKey.set(key, this.myHashingStrategy.computeHashCode(key));
        HardKey hardKey2 = hardKey;
        if (hardKey2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(7);
        }
        return hardKey2;
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(8);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
        Object v2 = org.jetbrains.kotlin.com.intellij.reference.SoftReference.deref(valueReference);
        ((HardKey)hardKey).clear();
        return (V)v2;
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMap.pointlessContainsValue();
    }

    @Override
    public V remove(Object key) {
        this.processQueues();
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.remove(hardKey);
        Object v2 = org.jetbrains.kotlin.com.intellij.reference.SoftReference.deref(valueReference);
        ((HardKey)hardKey).clear();
        return (V)v2;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(9);
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> prevValReference = this.myMap.put(keyReference, valueReference);
        return (V)org.jetbrains.kotlin.com.intellij.reference.SoftReference.deref(prevValReference);
    }

    private boolean processQueues() {
        ValueReference valueReference;
        KeyReference keyReference;
        boolean removed2 = false;
        while ((keyReference = (KeyReference)((Object)this.myKeyQueue.poll())) != null) {
            valueReference = keyReference.getValueReference();
            removed2 |= this.myMap.remove(keyReference, valueReference);
        }
        while ((valueReference = (ValueReference)((Object)this.myValueQueue.poll())) != null) {
            keyReference = valueReference.getKeyReference();
            removed2 |= this.myMap.remove(keyReference, valueReference);
        }
        return removed2;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(10);
        }
        if (value == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(11);
        }
        this.processQueues();
        HardKey<K, V> hardKey = this.createHardKey(key);
        ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
        Object v2 = org.jetbrains.kotlin.com.intellij.reference.SoftReference.deref(valueReference);
        boolean result2 = value.equals(v2) && this.myMap.remove(hardKey, valueReference);
        ((HardKey)hardKey).clear();
        return result2;
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        V oldVal;
        block4: {
            ValueReference<K, V> oldRef;
            if (key == null) {
                ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(12);
            }
            if (value == null) {
                ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(13);
            }
            KeyReference<K, V> keyRef = this.createKeyReference(key, value);
            ValueReference<K, V> newRef = keyRef.getValueReference();
            do {
                this.processQueues();
                oldRef = this.myMap.putIfAbsent(keyRef, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block4;
            } while (!this.myMap.replace(keyRef, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(14);
        }
        if (oldValue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(15);
        }
        if (newValue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(16);
        }
        this.processQueues();
        KeyReference<K, V> oldKeyReference = this.createKeyReference(key, oldValue);
        ValueReference<K, V> oldValueReference = oldKeyReference.getValueReference();
        KeyReference<K, V> newKeyReference = this.createKeyReference(key, newValue);
        ValueReference<K, V> newValueReference = newKeyReference.getValueReference();
        return this.myMap.replace(oldKeyReference, oldValueReference, newValueReference);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(17);
        }
        if (value == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(18);
        }
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> result2 = this.myMap.replace(keyReference, valueReference);
        return (V)org.jetbrains.kotlin.com.intellij.reference.SoftReference.deref(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createKeyReference";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createValueReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HardKey<K, V>
    implements KeyReference<K, V> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        private void set(@NotNull K key, int hash) {
            if (key == null) {
                HardKey.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myHash = hash;
        }

        private void clear() {
            this.myKey = null;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        public boolean equals(Object o) {
            return o.equals(this);
        }

        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$HardKey", "set"));
        }
    }

    static class SoftValue<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        @NotNull
        volatile KeyReference<K, V> myKeyReference;

        private SoftValue(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
            if (value == null) {
                SoftValue.$$$reportNull$$$0(0);
            }
            if (queue == null) {
                SoftValue.$$$reportNull$$$0(1);
            }
            super(value, queue);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Object v2 = this.get();
            Object thatV = ((ValueReference)o).get();
            return v2 != null && thatV != null && v2.equals(thatV);
        }

        @Override
        @NotNull
        public KeyReference<K, V> getKeyReference() {
            KeyReference<K, V> keyReference = this.myKeyReference;
            if (keyReference == null) {
                SoftValue.$$$reportNull$$$0(2);
            }
            return keyReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class WeakKey<K, V>
    extends WeakReference<K>
    implements KeyReference<K, V> {
        private final int myHash;
        private final TObjectHashingStrategy<? super K> myStrategy;
        @NotNull
        private final ValueReference<K, V> myValueReference;

        WeakKey(@NotNull K k, @NotNull ValueReference<K, V> valueReference, @NotNull TObjectHashingStrategy<? super K> strategy, @NotNull ReferenceQueue<? super K> queue) {
            if (k == null) {
                WeakKey.$$$reportNull$$$0(0);
            }
            if (valueReference == null) {
                WeakKey.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                WeakKey.$$$reportNull$$$0(2);
            }
            if (queue == null) {
                WeakKey.$$$reportNull$$$0(3);
            }
            super(k, queue);
            this.myValueReference = valueReference;
            this.myHash = strategy.computeHashCode(k);
            this.myStrategy = strategy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object other = ((KeyReference)o).get();
            if (t == null || other == null) {
                return false;
            }
            if (t == other) {
                return true;
            }
            return this.myHash == o.hashCode() && this.myStrategy.equals(t, other);
        }

        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            ValueReference<K, V> valueReference = this.myValueReference;
            if (valueReference == null) {
                WeakKey.$$$reportNull$$$0(4);
            }
            return valueReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "k";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ValueReference<K, V>
    extends Getter<V> {
        @NotNull
        public KeyReference<K, V> getKeyReference();

        @Override
        public V get();
    }

    public static interface KeyReference<K, V>
    extends Getter<K> {
        @Override
        public K get();

        @NotNull
        public ValueReference<K, V> getValueReference();
    }
}

