/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.DeprecationLogger;

public class DefaultSourceSetOutput
extends CompositeFileCollection
implements SourceSetOutput {
    private final DefaultConfigurableFileCollection outputDirectories;
    private Object resourcesDir;
    private final DefaultConfigurableFileCollection classesDirs;
    private final DefaultConfigurableFileCollection dirs;
    private final FileResolver fileResolver;

    public DefaultSourceSetOutput(String sourceSetDisplayName, FileResolver fileResolver, TaskResolver taskResolver) {
        this.fileResolver = fileResolver;
        String displayName = sourceSetDisplayName + " classes";
        this.classesDirs = new DefaultConfigurableFileCollection("classesDirs", (PathToFileResolver)fileResolver, taskResolver);
        this.classesDirs.builtBy(new Object[]{this});
        this.outputDirectories = new DefaultConfigurableFileCollection(displayName, (PathToFileResolver)fileResolver, taskResolver);
        this.outputDirectories.from(new Object[]{new Callable(){

            public Object call() {
                return DefaultSourceSetOutput.this.classesDirs;
            }
        }, new Callable(){

            public Object call() {
                return DefaultSourceSetOutput.this.getResourcesDir();
            }
        }});
        this.dirs = new DefaultConfigurableFileCollection("dirs", (PathToFileResolver)fileResolver, taskResolver);
    }

    public void visitContents(FileCollectionResolveContext context) {
        context.add((Object)this.outputDirectories);
    }

    public String getDisplayName() {
        return this.outputDirectories.getDisplayName();
    }

    public ConfigurableFileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public void addClassesDir(Callable<File> classesDir) {
        this.classesDirs.from(new Object[]{classesDir});
    }

    @Override
    public boolean isLegacyLayout() {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"legacyLayout", (String)"The method always returns false.");
        return false;
    }

    @Override
    @Nullable
    public File getResourcesDir() {
        if (this.resourcesDir == null) {
            return null;
        }
        return this.fileResolver.resolve(this.resourcesDir);
    }

    @Override
    public void setResourcesDir(File resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    @Override
    public void setResourcesDir(Object resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    public void builtBy(Object ... taskPaths) {
        this.outputDirectories.builtBy(taskPaths);
    }

    @Override
    public void dir(Object dir) {
        this.dir(Collections.<String, Object>emptyMap(), dir);
    }

    @Override
    public void dir(Map<String, Object> options, Object dir) {
        this.dirs.from(new Object[]{dir});
        this.outputDirectories.from(new Object[]{dir});
        Object builtBy = options.get("builtBy");
        if (builtBy != null) {
            this.builtBy(builtBy);
            this.dirs.builtBy(new Object[]{builtBy});
        }
    }

    @Override
    public FileCollection getDirs() {
        return this.dirs;
    }
}

