/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.compare.internal;

import java.util.List;
import java.util.Set;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparisonResult;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class BuildComparisonResult {
    private List<BuildOutcomeComparisonResult<?>> comparisons;
    private Set<BuildOutcome> uncomparedSourceOutcomes;
    private Set<BuildOutcome> uncomparedTargetOutcomes;

    public BuildComparisonResult(Set<BuildOutcome> uncomparedSourceOutcomes, Set<BuildOutcome> uncomparedTargetOutcomes, List<BuildOutcomeComparisonResult<?>> comparisons) {
        this.comparisons = comparisons;
        this.uncomparedSourceOutcomes = uncomparedSourceOutcomes;
        this.uncomparedTargetOutcomes = uncomparedTargetOutcomes;
    }

    public List<BuildOutcomeComparisonResult<?>> getComparisons() {
        return this.comparisons;
    }

    public Set<BuildOutcome> getUncomparedSourceOutcomes() {
        return this.uncomparedSourceOutcomes;
    }

    public Set<BuildOutcome> getUncomparedTargetOutcomes() {
        return this.uncomparedTargetOutcomes;
    }

    public boolean isBuildsAreIdentical() {
        if (!this.getUncomparedSourceOutcomes().isEmpty() || !this.getUncomparedTargetOutcomes().isEmpty()) {
            return false;
        }
        return CollectionUtils.every(this.comparisons, (Spec)new Spec<BuildOutcomeComparisonResult<?>>(){

            public boolean isSatisfiedBy(BuildOutcomeComparisonResult<?> comparisonResult) {
                return comparisonResult.isOutcomesAreIdentical();
            }
        });
    }
}

