/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.XmlProvider;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.visualstudio.XmlConfigFile;
import org.gradle.ide.visualstudio.internal.AbstractCppBinaryVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectMetadata;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.CollectionUtils;
import org.gradle.util.VersionNumber;

public class DefaultVisualStudioProject
implements VisualStudioProjectInternal {
    private final DefaultConfigFile projectFile;
    private final DefaultConfigFile filtersFile;
    private final String name;
    private final String componentName;
    private final Property<VersionNumber> visualStudioVersion;
    private final Property<VersionNumber> sdkVersion;
    private final List<File> additionalFiles = new ArrayList<File>();
    private final Map<VisualStudioTargetBinary, VisualStudioProjectConfiguration> configurations = new LinkedHashMap<VisualStudioTargetBinary, VisualStudioProjectConfiguration>();
    private final DefaultTaskDependency buildDependencies = new DefaultTaskDependency();
    private final ConfigurableFileCollection sourceFiles;
    private final ConfigurableFileCollection headerFiles;

    public DefaultVisualStudioProject(String name, String componentName, PathToFileResolver fileResolver, ObjectFactory objectFactory, ProviderFactory providerFactory) {
        this.name = name;
        this.componentName = componentName;
        this.visualStudioVersion = objectFactory.property(VersionNumber.class).convention((Object)AbstractCppBinaryVisualStudioTargetBinary.DEFAULT_VISUAL_STUDIO_VERSION);
        this.sdkVersion = objectFactory.property(VersionNumber.class).convention((Object)AbstractCppBinaryVisualStudioTargetBinary.DEFAULT_SDK_VERSION);
        this.projectFile = (DefaultConfigFile)objectFactory.newInstance(DefaultConfigFile.class, new Object[]{fileResolver, this.getName() + ".vcxproj"});
        this.filtersFile = (DefaultConfigFile)objectFactory.newInstance(DefaultConfigFile.class, new Object[]{fileResolver, this.getName() + ".vcxproj.filters"});
        this.sourceFiles = objectFactory.fileCollection().from(new Object[]{providerFactory.provider(() -> {
            LinkedHashSet allSourcesFromBinaries = new LinkedHashSet();
            for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
                allSourcesFromBinaries.addAll(binary.getSourceFiles().getFiles());
            }
            return allSourcesFromBinaries;
        }), providerFactory.provider(() -> this.additionalFiles)});
        this.headerFiles = objectFactory.fileCollection().from(new Object[]{providerFactory.provider(() -> {
            LinkedHashSet allHeadersFromBinaries = new LinkedHashSet();
            for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
                allHeadersFromBinaries.addAll(binary.getHeaderFiles().getFiles());
            }
            return allHeadersFromBinaries;
        })});
    }

    @Override
    @Input
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public DefaultConfigFile getProjectFile() {
        return this.projectFile;
    }

    @Override
    public DefaultConfigFile getFiltersFile() {
        return this.filtersFile;
    }

    public void addSourceFile(File sourceFile) {
        this.additionalFiles.add(sourceFile);
    }

    public static String getUUID(File projectFile) {
        return "{" + UUID.nameUUIDFromBytes(projectFile.getAbsolutePath().getBytes()).toString().toUpperCase() + "}";
    }

    @Internal
    public ConfigurableFileCollection getSourceFiles() {
        return this.sourceFiles;
    }

    @Input
    public Set<String> getSourceFilePaths() {
        return CollectionUtils.collect((Set)this.getSourceFiles().getFiles(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath();
            }
        });
    }

    @Internal
    public Set<File> getResourceFiles() {
        LinkedHashSet<File> allResources = new LinkedHashSet<File>();
        for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
            allResources.addAll(binary.getResourceFiles().getFiles());
        }
        return allResources;
    }

    @Input
    public Set<String> getResourceFilePaths() {
        return CollectionUtils.collect(this.getResourceFiles(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath();
            }
        });
    }

    @Internal
    public ConfigurableFileCollection getHeaderFiles() {
        return this.headerFiles;
    }

    @Input
    public Set<String> getHeaderFilePaths() {
        return CollectionUtils.collect((Set)this.getHeaderFiles().getFiles(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath();
            }
        });
    }

    @Nested
    public List<VisualStudioProjectConfiguration> getConfigurations() {
        if (this.configurations.isEmpty()) {
            return ImmutableList.of((Object)new VisualStudioProjectConfiguration(this, "unbuildable", null));
        }
        return CollectionUtils.toList(this.configurations.values());
    }

    public void addConfiguration(VisualStudioTargetBinary nativeBinary, VisualStudioProjectConfiguration configuration) {
        this.configurations.put(nativeBinary, configuration);
        this.builtBy(nativeBinary.getSourceFiles());
        this.builtBy(nativeBinary.getResourceFiles());
        this.builtBy(nativeBinary.getHeaderFiles());
    }

    @Internal
    public VisualStudioProjectConfiguration getConfiguration(VisualStudioTargetBinary nativeBinary) {
        return this.configurations.get(nativeBinary);
    }

    @Override
    public void builtBy(Object ... tasks) {
        this.buildDependencies.add(tasks);
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.buildDependencies;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Property<VersionNumber> getVisualStudioVersion() {
        return this.visualStudioVersion;
    }

    public Property<VersionNumber> getSdkVersion() {
        return this.sdkVersion;
    }

    @Override
    @Internal
    public IdeProjectMetadata getPublishArtifact() {
        return new VisualStudioProjectMetadata(this);
    }

    @Nested
    public List<Action<? super XmlProvider>> getProjectFileActions() {
        return this.projectFile.getXmlActions();
    }

    @Nested
    public List<Action<? super XmlProvider>> getFiltersFileActions() {
        return this.filtersFile.getXmlActions();
    }

    public static class DefaultConfigFile
    implements XmlConfigFile {
        private final List<Action<? super XmlProvider>> actions = new ArrayList<Action<? super XmlProvider>>();
        private final PathToFileResolver fileResolver;
        private Object location;

        @Inject
        public DefaultConfigFile(PathToFileResolver fileResolver, String defaultLocation) {
            this.fileResolver = fileResolver;
            this.location = defaultLocation;
        }

        @Override
        public File getLocation() {
            return this.fileResolver.resolve(this.location);
        }

        @Override
        public void setLocation(Object location) {
            this.location = location;
        }

        @Override
        public void withXml(Action<? super XmlProvider> action) {
            this.actions.add(action);
        }

        @Nested
        public List<Action<? super XmlProvider>> getXmlActions() {
            return this.actions;
        }
    }
}

