/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.util.HashSet;
import org.gradle.api.file.DuplicateFileCopyingException;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.WorkResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateHandlingCopyActionDecorator
implements CopyAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateHandlingCopyActionDecorator.class);
    private final CopyAction delegate;

    public DuplicateHandlingCopyActionDecorator(CopyAction delegate) {
        this.delegate = delegate;
    }

    @Override
    public WorkResult execute(final CopyActionProcessingStream stream) {
        final HashSet visitedFiles = new HashSet();
        return this.delegate.execute(new CopyActionProcessingStream(){

            @Override
            public void process(final CopyActionProcessingStreamAction action) {
                stream.process(new CopyActionProcessingStreamAction(){

                    @Override
                    public void processFile(FileCopyDetailsInternal details) {
                        if (!details.isDirectory()) {
                            DuplicatesStrategy strategy = details.getDuplicatesStrategy();
                            if (!visitedFiles.add(details.getRelativePath())) {
                                if (strategy == DuplicatesStrategy.EXCLUDE) {
                                    return;
                                }
                                if (strategy == DuplicatesStrategy.FAIL) {
                                    throw new DuplicateFileCopyingException(String.format("Encountered duplicate path \"%s\" during copy operation configured with DuplicatesStrategy.FAIL", details.getRelativePath()));
                                }
                                if (strategy == DuplicatesStrategy.WARN) {
                                    LOGGER.warn("Encountered duplicate path \"{}\" during copy operation configured with DuplicatesStrategy.WARN", (Object)details.getRelativePath());
                                }
                            }
                        }
                        action.processFile(details);
                    }
                });
            }
        });
    }
}

