/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.java.JavaLibraryPlatform;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JavaPluginsHelper;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.util.DeprecationLogger;

public class JavaPlugin
implements Plugin<ProjectInternal> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String IMPLEMENTATION_CONFIGURATION_NAME = "implementation";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String COMPILE_CONFIGURATION_NAME = "compile";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    public static final String RUNTIME_ONLY_CONFIGURATION_NAME = "runtimeOnly";
    public static final String RUNTIME_CLASSPATH_CONFIGURATION_NAME = "runtimeClasspath";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    @Incubating
    public static final String ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "annotationProcessor";
    public static final String TEST_COMPILE_CONFIGURATION_NAME = "testCompile";
    public static final String TEST_IMPLEMENTATION_CONFIGURATION_NAME = "testImplementation";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_CONFIGURATION_NAME = "testRuntime";
    public static final String TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "testRuntimeOnly";
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";
    @Incubating
    public static final String TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "testAnnotationProcessor";
    public static final String TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "testRuntimeClasspath";
    private final ObjectFactory objectFactory;
    private final SoftwareComponentFactory softwareComponentFactory;

    @Inject
    public JavaPlugin(ObjectFactory objectFactory, SoftwareComponentFactory softwareComponentFactory) {
        this.objectFactory = objectFactory;
        this.softwareComponentFactory = softwareComponentFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        ((ComponentRegistry)project.getServices().get(ComponentRegistry.class)).setMainComponent((BuildableJavaComponent)new BuildableJavaComponentImpl(javaConvention));
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = (BuildOutputCleanupRegistry)project.getServices().get(BuildOutputCleanupRegistry.class);
        this.configureSourceSets(javaConvention, buildOutputCleanupRegistry);
        this.configureConfigurations((Project)project, javaConvention);
        this.configureJavaDoc(javaConvention);
        this.configureTest((Project)project, javaConvention);
        this.configureArchivesAndComponent((Project)project, javaConvention);
        this.configureBuild((Project)project);
        if (project.getPluginManager().hasPlugin("java-platform")) {
            DeprecationLogger.nagUserOfDeprecatedBehaviour((String)"The \"java\" (or \"java-library\") plugin cannot be used together with the \"java-platform\" plugin on a given project. A project is either a platform or a library but cannot be both at the same time.");
        }
    }

    private void configureSourceSets(JavaPluginConvention pluginConvention, final BuildOutputCleanupRegistry buildOutputCleanupRegistry) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet main = (SourceSet)pluginConvention.getSourceSets().create("main");
        SourceSet test = (SourceSet)pluginConvention.getSourceSets().create(TEST_TASK_NAME);
        test.setCompileClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{main.getOutput(), project.getConfigurations().getByName(TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME)}));
        test.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{test.getOutput(), main.getOutput(), project.getConfigurations().getByName(TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME)}));
        pluginConvention.getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(SourceSet sourceSet) {
                buildOutputCleanupRegistry.registerOutputs((Object)sourceSet.getOutput());
            }
        });
    }

    private void configureJavaDoc(final JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        project.getTasks().register(JAVADOC_TASK_NAME, Javadoc.class, (Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                SourceSet mainSourceSet = (SourceSet)pluginConvention.getSourceSets().getByName("main");
                javadoc.setDescription("Generates Javadoc API documentation for the main source code.");
                javadoc.setGroup("documentation");
                javadoc.setClasspath(mainSourceSet.getOutput().plus(mainSourceSet.getCompileClasspath()));
                javadoc.setSource((FileTree)mainSourceSet.getAllJava());
            }
        });
    }

    private void configureArchivesAndComponent(Project project, final JavaPluginConvention pluginConvention) {
        TaskProvider jar = project.getTasks().register(JAR_TASK_NAME, Jar.class, (Action)new Action<Jar>(){

            public void execute(Jar jar) {
                jar.setDescription("Assembles a jar archive containing the main classes.");
                jar.setGroup("build");
                jar.from(new Object[]{((SourceSet)pluginConvention.getSourceSets().getByName("main")).getOutput()});
            }
        });
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact((Provider)jar);
        Configuration apiElementConfiguration = project.getConfigurations().getByName(API_ELEMENTS_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration runtimeElementsConfiguration = project.getConfigurations().getByName(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)jarArtifact);
        TaskProvider javaCompile = project.getTasks().named(COMPILE_JAVA_TASK_NAME, JavaCompile.class);
        TaskProvider processResources = project.getTasks().named(PROCESS_RESOURCES_TASK_NAME, ProcessResources.class);
        this.addJar(apiElementConfiguration, (PublishArtifact)jarArtifact);
        this.addJar(runtimeConfiguration, (PublishArtifact)jarArtifact);
        this.addRuntimeVariants(runtimeElementsConfiguration, (PublishArtifact)jarArtifact, (Provider<JavaCompile>)javaCompile, (Provider<ProcessResources>)processResources);
        this.registerSoftwareComponents(project);
        project.getComponents().add(this.objectFactory.newInstance(JavaLibraryPlatform.class, new Object[]{project.getConfigurations()}));
    }

    private void registerSoftwareComponents(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        AdhocComponentWithVariants java = this.softwareComponentFactory.adhoc("java");
        java.addVariantsFromConfiguration(configurations.getByName(API_ELEMENTS_CONFIGURATION_NAME), (Action)new JavaConfigurationVariantMapping(COMPILE_CONFIGURATION_NAME, false));
        java.addVariantsFromConfiguration(configurations.getByName(RUNTIME_ELEMENTS_CONFIGURATION_NAME), (Action)new JavaConfigurationVariantMapping(RUNTIME_CONFIGURATION_NAME, false));
        project.getComponents().add((Object)java);
    }

    private void addJar(Configuration configuration, PublishArtifact jarArtifact) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)JAR_TASK_NAME);
    }

    private void addRuntimeVariants(Configuration configuration, PublishArtifact jarArtifact, final Provider<JavaCompile> javaCompile, final Provider<ProcessResources> processResources) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)JAR_TASK_NAME);
        NamedDomainObjectContainer runtimeVariants = publications.getVariants();
        ConfigurationVariant classesVariant = (ConfigurationVariant)runtimeVariants.create(CLASSES_TASK_NAME);
        classesVariant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.objectFactory.named(Usage.class, "java-runtime-classes"));
        classesVariant.artifact((Object)new JavaPluginsHelper.IntermediateJavaArtifact("java-classes-directory", javaCompile){

            public File getFile() {
                return ((JavaCompile)javaCompile.get()).getDestinationDir();
            }
        });
        ConfigurationVariant resourcesVariant = (ConfigurationVariant)runtimeVariants.create("resources");
        resourcesVariant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.objectFactory.named(Usage.class, "java-runtime-resources"));
        resourcesVariant.artifact((Object)new JavaPluginsHelper.IntermediateJavaArtifact("java-resources-directory", processResources){

            public File getFile() {
                return ((ProcessResources)processResources.get()).getDestinationDir();
            }
        });
    }

    private void configureBuild(Project project) {
        project.getTasks().named("buildNeeded", (Action)new Action<Task>(){

            public void execute(Task task) {
                JavaPlugin.this.addDependsOnTaskInOtherProjects(task, true, "buildNeeded", JavaPlugin.TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME);
            }
        });
        project.getTasks().named("buildDependents", (Action)new Action<Task>(){

            public void execute(Task task) {
                JavaPlugin.this.addDependsOnTaskInOtherProjects(task, false, "buildDependents", JavaPlugin.TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME);
            }
        });
    }

    private void configureTest(Project project, final JavaPluginConvention pluginConvention) {
        project.getTasks().withType(Test.class).configureEach((Action)new Action<Test>(){

            public void execute(Test test) {
                test.getConventionMapping().map("testClassesDirs", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getOutput().getClassesDirs();
                    }
                });
                test.getConventionMapping().map("classpath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getRuntimeClasspath();
                    }
                });
            }
        });
        TaskProvider test = project.getTasks().register(TEST_TASK_NAME, Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                test.setDescription("Runs the unit tests.");
                test.setGroup("verification");
            }
        });
        project.getTasks().named("check", (Action)new Action<Task>((Provider)test){
            final /* synthetic */ Provider val$test;
            {
                this.val$test = provider;
            }

            public void execute(Task task) {
                task.dependsOn(new Object[]{this.val$test});
            }
        });
    }

    private void configureConfigurations(Project project, JavaPluginConvention convention) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration defaultConfiguration = configurations.getByName("default");
        Configuration compileConfiguration = configurations.getByName(COMPILE_CONFIGURATION_NAME);
        Configuration implementationConfiguration = configurations.getByName(IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = configurations.getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration runtimeOnlyConfiguration = configurations.getByName(RUNTIME_ONLY_CONFIGURATION_NAME);
        Configuration compileTestsConfiguration = configurations.getByName(TEST_COMPILE_CONFIGURATION_NAME);
        Configuration testImplementationConfiguration = configurations.getByName(TEST_IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration testRuntimeConfiguration = configurations.getByName(TEST_RUNTIME_CONFIGURATION_NAME);
        Configuration testRuntimeOnlyConfiguration = configurations.getByName(TEST_RUNTIME_ONLY_CONFIGURATION_NAME);
        compileTestsConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        testImplementationConfiguration.extendsFrom(new Configuration[]{implementationConfiguration});
        testRuntimeConfiguration.extendsFrom(new Configuration[]{runtimeConfiguration});
        testRuntimeOnlyConfiguration.extendsFrom(new Configuration[]{runtimeOnlyConfiguration});
        Configuration apiElementsConfiguration = (Configuration)configurations.maybeCreate(API_ELEMENTS_CONFIGURATION_NAME);
        apiElementsConfiguration.setVisible(false);
        apiElementsConfiguration.setDescription("API elements for main.");
        apiElementsConfiguration.setCanBeResolved(false);
        apiElementsConfiguration.setCanBeConsumed(true);
        apiElementsConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.objectFactory.named(Usage.class, "java-api-jars"));
        apiElementsConfiguration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)this.objectFactory.named(Bundling.class, "external"));
        apiElementsConfiguration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)this.objectFactory.named(Category.class, "library"));
        apiElementsConfiguration.extendsFrom(new Configuration[]{runtimeConfiguration});
        Configuration runtimeElementsConfiguration = (Configuration)configurations.maybeCreate(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        runtimeElementsConfiguration.setVisible(false);
        runtimeElementsConfiguration.setCanBeConsumed(true);
        runtimeElementsConfiguration.setCanBeResolved(false);
        runtimeElementsConfiguration.setDescription("Elements of runtime for main.");
        runtimeElementsConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.objectFactory.named(Usage.class, "java-runtime-jars"));
        runtimeElementsConfiguration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)this.objectFactory.named(Bundling.class, "external"));
        runtimeElementsConfiguration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)this.objectFactory.named(Category.class, "library"));
        runtimeElementsConfiguration.extendsFrom(new Configuration[]{implementationConfiguration, runtimeOnlyConfiguration, runtimeConfiguration});
        defaultConfiguration.extendsFrom(new Configuration[]{runtimeElementsConfiguration});
        this.configureTargetPlatform(apiElementsConfiguration, convention);
        this.configureTargetPlatform(runtimeElementsConfiguration, convention);
    }

    private void configureTargetPlatform(Configuration outgoing, final JavaPluginConvention convention) {
        ((ConfigurationInternal)outgoing).beforeLocking((Action)new Action<ConfigurationInternal>(){

            public void execute(ConfigurationInternal configuration) {
                JavaEcosystemSupport.configureDefaultTargetPlatform((HasAttributes)configuration, (JavaVersion)convention.getTargetCompatibility());
            }
        });
    }

    private void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(new Object[]{configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName)});
    }

    private static class BuildableJavaComponentImpl
    implements BuildableJavaComponent {
        private final JavaPluginConvention convention;

        public BuildableJavaComponentImpl(JavaPluginConvention convention) {
            this.convention = convention;
        }

        public Collection<String> getBuildTasks() {
            return Collections.singleton("build");
        }

        public FileCollection getRuntimeClasspath() {
            ProjectInternal project = this.convention.getProject();
            SourceSet mainSourceSet = (SourceSet)this.convention.getSourceSets().getByName("main");
            FileCollection runtimeClasspath = mainSourceSet.getRuntimeClasspath();
            Configuration gradleApi = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().gradleApi(), project.getDependencies().localGroovy()});
            Configuration runtimeElements = project.getConfigurations().getByName(mainSourceSet.getRuntimeElementsConfigurationName());
            FileCollection mainSourceSetArtifact = runtimeElements.getOutgoing().getArtifacts().getFiles();
            return mainSourceSetArtifact.plus(runtimeClasspath.minus((FileCollection)mainSourceSet.getOutput()).minus((FileCollection)gradleApi));
        }

        public Configuration getCompileDependencies() {
            return this.convention.getProject().getConfigurations().getByName(JavaPlugin.COMPILE_CLASSPATH_CONFIGURATION_NAME);
        }
    }
}

