/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionLeafVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.tasks.PropertyFileCollection;
import org.gradle.api.internal.tasks.properties.CompositeOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.DefaultCacheableOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.AbsolutePathInputNormalizer;
import org.gradle.internal.fingerprint.IgnoredPathInputNormalizer;
import org.gradle.internal.fingerprint.NameOnlyInputNormalizer;
import org.gradle.internal.fingerprint.RelativePathInputNormalizer;
import org.gradle.util.DeferredUtil;

public class FileParameterUtils {
    public static Class<? extends FileNormalizer> determineNormalizerForPathSensitivity(PathSensitivity pathSensitivity) {
        switch (pathSensitivity) {
            case NONE: {
                return IgnoredPathInputNormalizer.class;
            }
            case NAME_ONLY: {
                return NameOnlyInputNormalizer.class;
            }
            case RELATIVE: {
                return RelativePathInputNormalizer.class;
            }
            case ABSOLUTE: {
                return AbsolutePathInputNormalizer.class;
            }
        }
        throw new IllegalArgumentException("Unknown path sensitivity: " + pathSensitivity);
    }

    public static Class<? extends FileNormalizer> normalizerOrDefault(@Nullable Class<? extends FileNormalizer> fileNormalizer) {
        return fileNormalizer == null ? AbsolutePathInputNormalizer.class : fileNormalizer;
    }

    public static <T extends FilePropertySpec> ImmutableSortedSet<T> collectFileProperties(String displayName, Iterator<? extends T> fileProperties) {
        HashSet names = Sets.newHashSet();
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        while (fileProperties.hasNext()) {
            FilePropertySpec propertySpec = (FilePropertySpec)fileProperties.next();
            String propertyName = propertySpec.getPropertyName();
            if (!names.add(propertyName)) {
                throw new IllegalArgumentException(String.format("Multiple %s file properties with name '%s'", displayName, propertyName));
            }
            builder.add((Object)propertySpec);
        }
        return builder.build();
    }

    public static FileCollection resolveInputFileValue(FileCollectionFactory fileCollectionFactory, InputFilePropertyType inputFilePropertyType, Object path) {
        if (inputFilePropertyType == InputFilePropertyType.DIRECTORY) {
            return fileCollectionFactory.resolving(path).getAsFileTree();
        }
        return fileCollectionFactory.resolving(path);
    }

    public static void resolveOutputFilePropertySpecs(String ownerDisplayName, String propertyName, PropertyValue value, OutputFilePropertyType filePropertyType, FileCollectionFactory fileCollectionFactory, Consumer<OutputFilePropertySpec> consumer) {
        Object unpackedValue = DeferredUtil.unpack((Object)value);
        if (unpackedValue == null) {
            return;
        }
        if (filePropertyType == OutputFilePropertyType.DIRECTORIES || filePropertyType == OutputFilePropertyType.FILES) {
            FileParameterUtils.resolveCompositeOutputFilePropertySpecs(ownerDisplayName, propertyName, unpackedValue, filePropertyType.getOutputType(), fileCollectionFactory, consumer);
        } else {
            FileCollectionInternal outputFiles = fileCollectionFactory.resolving(unpackedValue);
            DefaultCacheableOutputFilePropertySpec filePropertySpec = new DefaultCacheableOutputFilePropertySpec(propertyName, null, (FileCollection)outputFiles, filePropertyType.getOutputType());
            consumer.accept(filePropertySpec);
        }
    }

    private static void resolveCompositeOutputFilePropertySpecs(String ownerDisplayName, String propertyName, Object unpackedValue, TreeType outputType, FileCollectionFactory fileCollectionFactory, Consumer<OutputFilePropertySpec> consumer) {
        if (unpackedValue instanceof Map) {
            for (Map.Entry entry : ((Map)unpackedValue).entrySet()) {
                Object key = entry.getKey();
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Mapped output property '%s' has null key", propertyName));
                }
                String id = key.toString();
                FileCollectionInternal outputFiles = fileCollectionFactory.resolving(entry.getValue());
                consumer.accept(new DefaultCacheableOutputFilePropertySpec(propertyName, "." + id, (FileCollection)outputFiles, outputType));
            }
        } else {
            final ArrayList roots = Lists.newArrayList();
            final MutableBoolean nonFileRoot = new MutableBoolean();
            FileCollectionInternal outputFileCollection = fileCollectionFactory.resolving(unpackedValue);
            outputFileCollection.visitLeafCollections(new FileCollectionLeafVisitor(){

                public void visitCollection(FileCollectionInternal fileCollection) {
                    Iterables.addAll((Collection)roots, (Iterable)fileCollection);
                }

                public void visitGenericFileTree(FileTreeInternal fileTree) {
                    nonFileRoot.set(true);
                }

                public void visitFileTree(File root, PatternSet patterns) {
                    nonFileRoot.set(true);
                }
            });
            if (nonFileRoot.get()) {
                consumer.accept(new CompositeOutputFilePropertySpec(propertyName, (FileCollection)new PropertyFileCollection(ownerDisplayName, propertyName, "output", (FileCollection)fileCollectionFactory.resolving(unpackedValue)), outputType));
            } else {
                int index = 0;
                for (File root : roots) {
                    FileCollectionInternal outputFiles = fileCollectionFactory.fixed(root);
                    consumer.accept(new DefaultCacheableOutputFilePropertySpec(propertyName, "$" + ++index, (FileCollection)outputFiles, outputType));
                }
            }
        }
    }
}

