/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.internal.reflect.Methods;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.Types;
import org.gradle.util.CollectionUtils;

public class PropertyExtractor {
    private final String displayName;
    private final Set<Class<? extends Annotation>> primaryAnnotationTypes;
    private final Set<Class<? extends Annotation>> relevantAnnotationTypes;
    private final Multimap<Class<? extends Annotation>, Class<? extends Annotation>> annotationOverrides;
    private final Set<Class<? extends Annotation>> otherKnownAnnotations;
    private final Set<Class<?>> ignoredSuperclasses;
    private final Set<Equivalence.Wrapper<Method>> ignoredMethods;

    public PropertyExtractor(String displayName, Set<Class<? extends Annotation>> primaryAnnotationTypes, Set<Class<? extends Annotation>> relevantAnnotationTypes, Multimap<Class<? extends Annotation>, Class<? extends Annotation>> annotationOverrides, Set<Class<? extends Annotation>> otherKnownAnnotations, Set<Class<?>> ignoredSuperclasses, Set<Class<?>> ignoreMethodsFromClasses) {
        this.displayName = displayName;
        this.primaryAnnotationTypes = primaryAnnotationTypes;
        this.relevantAnnotationTypes = relevantAnnotationTypes;
        this.annotationOverrides = annotationOverrides;
        this.otherKnownAnnotations = otherKnownAnnotations;
        this.ignoredSuperclasses = ignoredSuperclasses;
        this.ignoredMethods = PropertyExtractor.allMethodsOf(ignoreMethodsFromClasses);
    }

    private static ImmutableSet<Equivalence.Wrapper<Method>> allMethodsOf(Iterable<Class<?>> classes) {
        ArrayList methods = Lists.newArrayList();
        for (Class<?> clazz : classes) {
            for (Method method : clazz.getMethods()) {
                methods.add(Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method));
            }
        }
        return ImmutableSet.copyOf((Collection)methods);
    }

    public <T> ImmutableSet<PropertyMetadata> extractPropertyMetadata(Class<T> type, final ParameterValidationContext validationContext) {
        final Set<Class<? extends Annotation>> propertyTypeAnnotations = this.primaryAnnotationTypes;
        final LinkedHashMap properties = Maps.newLinkedHashMap();
        Types.walkTypeHierarchy(type, this.ignoredSuperclasses, new Types.TypeVisitor<T>(){

            @Override
            public void visitType(Class<? super T> type) {
                if (type.isSynthetic()) {
                    return;
                }
                Map fields = PropertyExtractor.getFields(type);
                List getters = PropertyExtractor.this.getGetters(type);
                for (Getter getter : getters) {
                    String fieldName;
                    Field field;
                    Method method = getter.getMethod();
                    if (method.isSynthetic() || (field = (Field)fields.get(fieldName = getter.getName())) != null && field.isSynthetic()) continue;
                    PropertyMetadataBuilder propertyMetadata = (PropertyMetadataBuilder)properties.get(fieldName);
                    if (propertyMetadata == null) {
                        propertyMetadata = new PropertyMetadataBuilder(propertyTypeAnnotations, fieldName, method);
                        properties.put(fieldName, propertyMetadata);
                    }
                    Iterable declaredAnnotations = PropertyExtractor.this.mergeDeclaredAnnotations(method, field, propertyMetadata, validationContext);
                    Iterable overriddenAnnotations = PropertyExtractor.this.filterOverridingAnnotations(declaredAnnotations, propertyTypeAnnotations);
                    PropertyExtractor.this.recordAnnotations(propertyMetadata, overriddenAnnotations, declaredAnnotations, propertyTypeAnnotations, validationContext);
                }
            }
        });
        ImmutableSet.Builder propertyBuilder = ImmutableSet.builderWithExpectedSize((int)properties.size());
        for (PropertyMetadataBuilder property : properties.values()) {
            this.validateProperty(property, validationContext);
            if (property.propertyType == null) continue;
            propertyBuilder.add((Object)property.toMetadata());
        }
        return propertyBuilder.build();
    }

    private void validateProperty(PropertyMetadataBuilder property, ParameterValidationContext validationContext) {
        if (!property.brokenType && property.propertyType == null) {
            validationContext.visitError(null, property.fieldName, "is not annotated with " + this.displayName);
        }
    }

    private Iterable<Annotation> mergeDeclaredAnnotations(Method method, @Nullable Field field, PropertyMetadataBuilder property, ParameterValidationContext validationContext) {
        Collection<Annotation> methodAnnotations = this.collectRelevantAnnotations(method.getDeclaredAnnotations(), property, validationContext);
        if (Modifier.isPrivate(method.getModifiers())) {
            if (!methodAnnotations.isEmpty()) {
                validationContext.visitError(null, property.fieldName, "is private and annotated with @" + methodAnnotations.iterator().next().annotationType().getSimpleName());
            }
            property.hasBrokenType();
        }
        if (field == null) {
            return methodAnnotations;
        }
        Collection<Annotation> fieldAnnotations = this.collectRelevantAnnotations(field.getDeclaredAnnotations(), property, validationContext);
        if (fieldAnnotations.isEmpty()) {
            return methodAnnotations;
        }
        if (methodAnnotations.isEmpty()) {
            return fieldAnnotations;
        }
        for (Annotation methodAnnotation : methodAnnotations) {
            Iterator<Annotation> iFieldAnnotation = fieldAnnotations.iterator();
            while (iFieldAnnotation.hasNext()) {
                Annotation fieldAnnotation = iFieldAnnotation.next();
                if (!methodAnnotation.annotationType().equals(fieldAnnotation.annotationType())) continue;
                validationContext.visitError(null, property.fieldName, "has both a getter and field declared with annotation @" + methodAnnotation.annotationType().getSimpleName());
                iFieldAnnotation.remove();
            }
        }
        return Iterables.concat(methodAnnotations, fieldAnnotations);
    }

    private Iterable<Annotation> filterOverridingAnnotations(final Iterable<Annotation> declaredAnnotations, final Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        return Iterables.filter(declaredAnnotations, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                Class<? extends Annotation> annotationType = input.annotationType();
                if (!propertyTypeAnnotations.contains(annotationType)) {
                    return true;
                }
                for (Class overridingAnnotation : PropertyExtractor.this.annotationOverrides.get(annotationType)) {
                    for (Annotation declaredAnnotation : declaredAnnotations) {
                        if (!declaredAnnotation.annotationType().equals(overridingAnnotation)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private void recordAnnotations(PropertyMetadataBuilder property, Iterable<Annotation> overriddenAnnotations, Iterable<Annotation> annotations, Set<Class<? extends Annotation>> propertyTypeAnnotations, ParameterValidationContext validationContext) {
        LinkedHashSet declaredPropertyTypes = Sets.newLinkedHashSet();
        for (Annotation annotation : overriddenAnnotations) {
            if (!propertyTypeAnnotations.contains(annotation.annotationType())) continue;
            declaredPropertyTypes.add(annotation.annotationType());
            property.addAnnotation(annotation);
        }
        for (Annotation annotation : annotations) {
            property.addAnnotation(annotation);
        }
        if (declaredPropertyTypes.size() > 1) {
            Iterable names = Iterables.transform((Iterable)declaredPropertyTypes, (Function)new Function<Class<? extends Annotation>, String>(){

                public String apply(Class<? extends Annotation> annotationType) {
                    return "@" + annotationType.getSimpleName();
                }
            });
            Set sortedNames = (Set)CollectionUtils.addAll(new TreeSet(), (Iterable)names);
            validationContext.visitError(null, property.fieldName, "has conflicting property types declared: " + Joiner.on((String)", ").join((Iterable)sortedNames));
        }
    }

    private Collection<Annotation> collectRelevantAnnotations(Annotation[] annotations, PropertyMetadataBuilder property, ParameterValidationContext validationContext) {
        ArrayList relevantAnnotations = Lists.newArrayListWithCapacity((int)annotations.length);
        for (Annotation annotation : annotations) {
            if (this.relevantAnnotationTypes.contains(annotation.annotationType())) {
                relevantAnnotations.add(annotation);
            }
            if (!this.otherKnownAnnotations.contains(annotation.annotationType())) continue;
            validationContext.visitError(null, property.fieldName, "is annotated with unsupported annotation @" + annotation.annotationType().getSimpleName());
            property.hasBrokenType();
        }
        return relevantAnnotations;
    }

    private static Map<String, Field> getFields(Class<?> type) {
        HashMap fields = Maps.newHashMap();
        for (Field field : type.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private List<Getter> getGetters(Class<?> type) {
        Method[] methods = type.getDeclaredMethods();
        ArrayList getters = Lists.newArrayListWithCapacity((int)methods.length);
        for (Method method : methods) {
            PropertyAccessorType accessorType = PropertyAccessorType.of(method);
            if (accessorType == null || accessorType == PropertyAccessorType.SETTER || method.isBridge() || this.ignoredMethods.contains(Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method))) continue;
            getters.add(new Getter(method, accessorType.propertyNameFor(method)));
        }
        Collections.sort(getters);
        return getters;
    }

    private static class DefaultPropertyMetadata
    implements PropertyMetadata {
        private final String fieldName;
        private final Method method;
        private final Class<? extends Annotation> propertyType;
        private final ImmutableMap<Class<? extends Annotation>, Annotation> annotations;

        DefaultPropertyMetadata(String fieldName, Method method, Class<? extends Annotation> propertyType, ImmutableMap<Class<? extends Annotation>, Annotation> annotations) {
            this.fieldName = fieldName;
            this.method = method;
            this.propertyType = propertyType;
            this.annotations = annotations;
        }

        @Override
        public String getPropertyName() {
            return this.fieldName;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Override
        @Nullable
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)((Annotation)annotationType.cast(this.annotations.get(annotationType)));
        }

        @Override
        @Nullable
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public Class<?> getDeclaredType() {
            return this.method.getReturnType();
        }

        @Override
        public Method getGetterMethod() {
            return this.method;
        }
    }

    private static class PropertyMetadataBuilder {
        private final Set<Class<? extends Annotation>> propertyTypeAnnotations;
        private final String fieldName;
        private final Method method;
        private Class<? extends Annotation> propertyType;
        private final Map<Class<? extends Annotation>, Annotation> annotations = Maps.newHashMap();
        private boolean brokenType;

        PropertyMetadataBuilder(Set<Class<? extends Annotation>> propertyTypeAnnotations, String fieldName, Method method) {
            this.propertyTypeAnnotations = propertyTypeAnnotations;
            this.fieldName = fieldName;
            this.method = method;
        }

        public void hasBrokenType() {
            this.brokenType = true;
        }

        public void addAnnotation(Annotation annotation) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (this.propertyType == null && this.isPropertyTypeAnnotation(annotationType)) {
                this.propertyType = annotationType;
            }
            if (!this.isAnnotationPresent(annotation.annotationType())) {
                this.annotations.put(annotationType, annotation);
            }
        }

        boolean isPropertyTypeAnnotation(Class<? extends Annotation> annotationType) {
            return this.propertyTypeAnnotations.contains(annotationType);
        }

        boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Nullable
        <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)((Annotation)annotationType.cast(this.annotations.get(annotationType)));
        }

        PropertyMetadata toMetadata() {
            return new DefaultPropertyMetadata(this.fieldName, this.method, this.propertyType, (ImmutableMap<Class<? extends Annotation>, Annotation>)ImmutableMap.copyOf(this.annotations));
        }
    }

    private static class Getter
    implements Comparable<Getter> {
        private final Method method;
        private final String name;

        Getter(Method method, String name) {
            this.method = method;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public int compareTo(@Nonnull Getter o) {
            return this.method.getName().compareTo(o.method.getName());
        }
    }
}

