/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.List;
import java.util.TreeMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.CapabilitiesSupport;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.logging.text.TreeFormatter;

public class AmbiguousConfigurationSelectionException
extends RuntimeException {
    public AmbiguousConfigurationSelectionException(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent, boolean variantAware) {
        super(AmbiguousConfigurationSelectionException.generateMessage(fromConfigurationAttributes, attributeMatcher, matches, targetComponent, variantAware));
    }

    private static String generateMessage(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent, boolean variantAware) {
        TreeMap<String, ConfigurationMetadata> ambiguousConfigurations = new TreeMap<String, ConfigurationMetadata>();
        for (ConfigurationMetadata configurationMetadata : matches) {
            ambiguousConfigurations.put(configurationMetadata.getName(), configurationMetadata);
        }
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Cannot choose between the following " + (variantAware ? "variants" : "configurations") + " of ");
        formatter.append((CharSequence)targetComponent.getId().getDisplayName());
        formatter.startChildren();
        for (String configuration : ambiguousConfigurations.keySet()) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (ConfigurationMetadata ambiguousConf : ambiguousConfigurations.values()) {
            AmbiguousConfigurationSelectionException.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, ambiguousConf, variantAware);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    static void formatConfiguration(TreeFormatter formatter, ComponentResolveMetadata targetComponent, AttributeContainerInternal consumerAttributes, AttributeMatcher attributeMatcher, ConfigurationMetadata configuration, boolean variantAware) {
        ImmutableAttributes producerAttributes = configuration.getAttributes();
        if (variantAware) {
            formatter.node("Variant '");
        } else {
            formatter.node("Configuration '");
        }
        formatter.append((CharSequence)configuration.getName());
        formatter.append((CharSequence)"'");
        if (variantAware) {
            formatter.append((CharSequence)(" " + CapabilitiesSupport.prettifyCapabilities(targetComponent, configuration.getCapabilities().getCapabilities())));
        }
        AmbiguousConfigurationSelectionException.formatAttributeMatches(formatter, consumerAttributes, attributeMatcher, (AttributeContainerInternal)producerAttributes);
    }

    static void formatAttributeMatches(TreeFormatter formatter, AttributeContainerInternal consumerAttributes, AttributeMatcher attributeMatcher, AttributeContainerInternal producerAttributes) {
        TreeMap<String, Attribute> allAttributes = new TreeMap<String, Attribute>();
        for (Attribute attribute : producerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        for (Attribute attribute : consumerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        ImmutableAttributes immutableConsumer = consumerAttributes.asImmutable();
        ImmutableAttributes immutableProducer = producerAttributes.asImmutable();
        formatter.startChildren();
        for (Attribute attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast((Object)attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attribute.getName());
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) {
                    formatter.node("Required " + attributeName + " '" + consumerValue.get() + "' and found compatible value '" + producerValue.get() + "'.");
                    continue;
                }
                formatter.node("Required " + attributeName + " '" + consumerValue.get() + "' and found incompatible value '" + producerValue.get() + "'.");
                continue;
            }
            if (consumerValue.isPresent()) {
                formatter.node("Required " + attributeName + " '" + consumerValue.get() + "' but no value provided.");
                continue;
            }
            formatter.node("Found " + attributeName + " '" + producerValue.get() + "' but wasn't required.");
        }
        formatter.endChildren();
    }
}

