/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.JavaVersion;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.internal.ReusableAction;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.model.ObjectFactory;

public abstract class JavaEcosystemSupport {
    public static void configureSchema(AttributesSchema attributesSchema, ObjectFactory objectFactory) {
        JavaEcosystemSupport.configureUsage(attributesSchema, objectFactory);
        JavaEcosystemSupport.configureBundling(attributesSchema);
        JavaEcosystemSupport.configureTargetPlatform(attributesSchema);
    }

    public static void configureDefaultTargetPlatform(HasAttributes configuration, JavaVersion version) {
        String majorVersion = version.getMajorVersion();
        AttributeContainerInternal attributes = (AttributeContainerInternal)configuration.getAttributes();
        if (!attributes.contains(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE)) {
            attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, Integer.valueOf(majorVersion));
        }
    }

    private static void configureTargetPlatform(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy targetPlatformSchema = attributesSchema.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE);
        targetPlatformSchema.getCompatibilityRules().ordered((Comparator)Ordering.natural());
        targetPlatformSchema.getDisambiguationRules().pickLast((Comparator)Ordering.natural());
    }

    private static void configureBundling(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy bundlingSchema = attributesSchema.attribute(Bundling.BUNDLING_ATTRIBUTE);
        bundlingSchema.getCompatibilityRules().add(BundlingCompatibilityRules.class);
        bundlingSchema.getDisambiguationRules().add(BundlingDisambiguationRules.class);
    }

    private static void configureUsage(AttributesSchema attributesSchema, final ObjectFactory objectFactory) {
        AttributeMatchingStrategy usageSchema = attributesSchema.attribute(Usage.USAGE_ATTRIBUTE);
        usageSchema.getCompatibilityRules().add(UsageCompatibilityRules.class);
        usageSchema.getDisambiguationRules().add(UsageDisambiguationRules.class, (Action)new Action<ActionConfiguration>(){

            public void execute(ActionConfiguration actionConfiguration) {
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-api")});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-api-jars")});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-api-classes")});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-runtime")});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-runtime-jars")});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-runtime-classes")});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-runtime-resources")});
            }
        });
    }

    @VisibleForTesting
    public static class BundlingDisambiguationRules
    implements AttributeDisambiguationRule<Bundling>,
    ReusableAction {
        public void execute(MultipleCandidatesDetails<Bundling> details) {
            Bundling consumerValue = (Bundling)details.getConsumerValue();
            Set candidateValues = details.getCandidateValues();
            if (candidateValues.contains(consumerValue)) {
                details.closestMatch((Object)consumerValue);
                return;
            }
            if (consumerValue == null) {
                Bundling embedded = null;
                for (Bundling candidateValue : candidateValues) {
                    if ("external".equals(candidateValue.getName())) {
                        details.closestMatch((Object)candidateValue);
                        return;
                    }
                    if (!"embedded".equals(candidateValue.getName())) continue;
                    embedded = candidateValue;
                }
                if (embedded != null) {
                    details.closestMatch(embedded);
                }
            } else {
                String consumerValueName = consumerValue.getName();
                if ("external".equals(consumerValueName)) {
                    for (Bundling candidateValue : candidateValues) {
                        if (!"embedded".equals(candidateValue.getName())) continue;
                        details.closestMatch((Object)candidateValue);
                        return;
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public static class BundlingCompatibilityRules
    implements AttributeCompatibilityRule<Bundling>,
    ReusableAction {
        private static final Set<String> COMPATIBLE_WITH_EXTERNAL = ImmutableSet.of((Object)"embedded", (Object)"shadowed");

        public void execute(CompatibilityCheckDetails<Bundling> details) {
            Bundling consumerValue = (Bundling)details.getConsumerValue();
            Bundling producerValue = (Bundling)details.getProducerValue();
            if (consumerValue == null) {
                details.compatible();
                return;
            }
            String consumerValueName = consumerValue.getName();
            String producerValueName = producerValue.getName();
            if ("external".equals(consumerValueName)) {
                if (COMPATIBLE_WITH_EXTERNAL.contains(producerValueName)) {
                    details.compatible();
                }
            } else if ("embedded".equals(consumerValueName) && "shadowed".equals(producerValueName)) {
                details.compatible();
            }
        }
    }

    @VisibleForTesting
    public static class UsageCompatibilityRules
    implements AttributeCompatibilityRule<Usage>,
    ReusableAction {
        private static final Set<String> COMPATIBLE_WITH_JAVA_API = ImmutableSet.of((Object)"java-api-jars", (Object)"java-api-classes", (Object)"java-runtime-jars", (Object)"java-runtime-classes", (Object)"java-runtime");
        private static final Set<String> COMPATIBLE_WITH_JAVA_API_JARS = ImmutableSet.of((Object)"java-api", (Object)"java-runtime-jars", (Object)"java-runtime");
        private static final Set<String> COMPATIBLE_WITH_JAVA_API_CLASSES = ImmutableSet.of((Object)"java-api", (Object)"java-api-jars", (Object)"java-runtime-jars", (Object)"java-runtime-classes", (Object)"java-runtime");
        private static final Set<String> COMPATIBLE_WITH_JAVA_RUNTIME_CLASSES = ImmutableSet.of((Object)"java-runtime", (Object)"java-runtime-jars");
        private static final Set<String> COMPATIBLE_WITH_JAVA_RUNTIME_RESOURCES = ImmutableSet.of((Object)"java-runtime", (Object)"java-runtime-jars");

        public void execute(CompatibilityCheckDetails<Usage> details) {
            String consumerValue = ((Usage)details.getConsumerValue()).getName();
            String producerValue = ((Usage)details.getProducerValue()).getName();
            if (consumerValue.equals("java-api")) {
                if (COMPATIBLE_WITH_JAVA_API.contains(producerValue)) {
                    details.compatible();
                }
                return;
            }
            if (consumerValue.equals("java-api-classes")) {
                if (COMPATIBLE_WITH_JAVA_API_CLASSES.contains(producerValue)) {
                    details.compatible();
                }
                return;
            }
            if (consumerValue.equals("java-api-jars")) {
                if (COMPATIBLE_WITH_JAVA_API_JARS.contains(producerValue)) {
                    details.compatible();
                }
                return;
            }
            if (consumerValue.equals("java-runtime") && producerValue.equals("java-runtime-jars")) {
                details.compatible();
                return;
            }
            if (consumerValue.equals("java-runtime-classes") && COMPATIBLE_WITH_JAVA_RUNTIME_CLASSES.contains(producerValue)) {
                details.compatible();
                return;
            }
            if (consumerValue.equals("java-runtime-resources") && COMPATIBLE_WITH_JAVA_RUNTIME_RESOURCES.contains(producerValue)) {
                details.compatible();
                return;
            }
            if (consumerValue.equals("java-runtime-jars") && producerValue.equals("java-runtime")) {
                details.compatible();
            }
        }
    }

    @VisibleForTesting
    public static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage>,
    ReusableAction {
        final Usage javaApi;
        final Usage javaRuntime;
        final Usage javaApiJars;
        final Usage javaApiClasses;
        final Usage javaRuntimeJars;
        final Usage javaRuntimeClasses;
        final Usage javaRuntimeResources;
        final ImmutableSet<Usage> apiVariants;
        final ImmutableSet<Usage> runtimeVariants;

        @Inject
        UsageDisambiguationRules(Usage javaApi, Usage javaApiJars, Usage javaApiClasses, Usage javaRuntime, Usage javaRuntimeJars, Usage javaRuntimeClasses, Usage javaRuntimeResources) {
            this.javaApi = javaApi;
            this.javaApiJars = javaApiJars;
            this.javaApiClasses = javaApiClasses;
            this.apiVariants = ImmutableSet.of((Object)javaApi, (Object)javaApiJars, (Object)javaApiClasses);
            this.javaRuntime = javaRuntime;
            this.javaRuntimeJars = javaRuntimeJars;
            this.javaRuntimeClasses = javaRuntimeClasses;
            this.javaRuntimeResources = javaRuntimeResources;
            this.runtimeVariants = ImmutableSet.of((Object)javaRuntime, (Object)javaRuntimeJars, (Object)javaRuntimeClasses, (Object)javaRuntimeResources);
        }

        public void execute(MultipleCandidatesDetails<Usage> details) {
            Set candidateValues = details.getCandidateValues();
            Usage consumerValue = (Usage)details.getConsumerValue();
            if (consumerValue == null) {
                if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch((Object)this.javaRuntimeJars);
                } else if (candidateValues.contains(this.javaRuntime)) {
                    details.closestMatch((Object)this.javaRuntime);
                }
            } else if (candidateValues.contains(consumerValue)) {
                details.closestMatch((Object)consumerValue);
            } else if (this.apiVariants.contains((Object)consumerValue)) {
                if (candidateValues.contains(this.javaApiClasses)) {
                    details.closestMatch((Object)this.javaApiClasses);
                } else if (candidateValues.contains(this.javaApiJars)) {
                    details.closestMatch((Object)this.javaApiJars);
                } else if (candidateValues.contains(this.javaApi)) {
                    details.closestMatch((Object)this.javaApi);
                } else if (candidateValues.contains(this.javaRuntimeClasses)) {
                    details.closestMatch((Object)this.javaRuntimeClasses);
                } else if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch((Object)this.javaRuntimeJars);
                }
            } else if (this.runtimeVariants.contains((Object)consumerValue)) {
                if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch((Object)this.javaRuntimeJars);
                } else if (candidateValues.contains(this.javaRuntime)) {
                    details.closestMatch((Object)this.javaRuntime);
                }
            }
        }
    }
}

