/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dsl.ComponentSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;
import org.gradle.internal.Describables;

public class DefaultDependencySubstitution
implements DependencySubstitutionInternal {
    private final ComponentSelector requested;
    private List<ComponentSelectionDescriptorInternal> ruleDescriptors;
    private ComponentSelector target;

    public DefaultDependencySubstitution(ComponentSelector requested) {
        this.requested = requested;
        this.target = requested;
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public void useTarget(Object notation) {
        this.useTarget(notation, ComponentSelectionReasons.SELECTED_BY_RULE);
    }

    public void useTarget(Object notation, String reason) {
        this.useTarget(notation, new DefaultComponentSelectionDescriptor(ComponentSelectionCause.SELECTED_BY_RULE, (Describable)Describables.of((Object)reason)));
    }

    @Override
    public void useTarget(Object notation, ComponentSelectionDescriptor ruleDescriptor) {
        this.target = (ComponentSelector)ComponentSelectorParsers.parser().parseNotation(notation);
        if (this.ruleDescriptors == null) {
            this.ruleDescriptors = Lists.newArrayList();
        }
        this.ruleDescriptors.add((ComponentSelectionDescriptorInternal)ruleDescriptor);
        DefaultDependencySubstitution.validateTarget(this.target);
    }

    @Override
    public List<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
        return this.ruleDescriptors == null ? Collections.emptyList() : this.ruleDescriptors;
    }

    @Override
    public ComponentSelector getTarget() {
        return this.target;
    }

    @Override
    public boolean isUpdated() {
        return this.ruleDescriptors != null;
    }

    public static void validateTarget(ComponentSelector componentSelector) {
        if (componentSelector instanceof UnversionedModuleComponentSelector) {
            throw new InvalidUserDataException("Must specify version for target of dependency substitution");
        }
    }
}

