/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyListIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtilRt {
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        HashMap hashMap = new HashMap(initialCapacity);
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(13);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = new LinkedList();
        if (linkedList == null) {
            ContainerUtilRt.$$$reportNull$$$0(20);
        }
        return linkedList;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(26);
        }
        ArrayList<T> list2 = ContainerUtilRt.newArrayListWithCapacity(elements.length);
        Collections.addAll(list2, elements);
        ArrayList<T> arrayList = list2;
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(28);
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            ArrayList arrayList = new ArrayList(collection);
            if (arrayList == null) {
                ContainerUtilRt.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        ArrayList<T> arrayList = ContainerUtilRt.copy(ContainerUtilRt.<T>newArrayList(), elements);
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = new ArrayList(size);
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    private static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(32);
        }
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(33);
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtilRt.$$$reportNull$$$0(34);
        }
        return c;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(37);
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(elements));
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(38);
        }
        return hashSet;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(39);
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            HashSet hashSet = new HashSet(collection);
            if (hashSet == null) {
                ContainerUtilRt.$$$reportNull$$$0(40);
            }
            return hashSet;
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(elements.iterator());
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(41);
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            ContainerUtilRt.$$$reportNull$$$0(42);
        }
        HashSet<T> set = ContainerUtilRt.newHashSet();
        while (iterator2.hasNext()) {
            set.add(iterator2.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(43);
        }
        return hashSet;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (linkedHashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(44);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(47);
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            LinkedHashSet linkedHashSet = new LinkedHashSet(collection);
            if (linkedHashSet == null) {
                ContainerUtilRt.$$$reportNull$$$0(48);
            }
            return linkedHashSet;
        }
        LinkedHashSet<T> linkedHashSet = ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedHashSet(), elements);
        if (linkedHashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(49);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = new Stack();
        if (stack == null) {
            ContainerUtilRt.$$$reportNull$$$0(56);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        EmptyList emptyList = EmptyList.INSTANCE;
        if (emptyList == null) {
            ContainerUtilRt.$$$reportNull$$$0(61);
        }
        return emptyList;
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result2, @Nullable T element) {
        if (result2 == null) {
            ContainerUtilRt.$$$reportNull$$$0(64);
        }
        if (element != null) {
            result2.add(element);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping2) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(68);
        }
        if (mapping2 == null) {
            ContainerUtilRt.$$$reportNull$$$0(69);
        }
        if (collection.isEmpty()) {
            List<T> list2 = ContainerUtilRt.emptyList();
            if (list2 == null) {
                ContainerUtilRt.$$$reportNull$$$0(70);
            }
            return list2;
        }
        ArrayList<T> result2 = new ArrayList<T>(collection.size());
        for (T t : collection) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtilRt.emptyList() : result2;
        if (list3 == null) {
            ContainerUtilRt.$$$reportNull$$$0(71);
        }
        return list3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(72);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(73);
        }
        if (collection.isEmpty()) {
            List<T> list2 = ContainerUtilRt.emptyList();
            if (list2 == null) {
                ContainerUtilRt.$$$reportNull$$$0(74);
            }
            return list2;
        }
        ArrayList<V> list3 = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list3.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list3;
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(75);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(79);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(80);
        }
        Set<? extends V> set = ContainerUtilRt.map2Set(Arrays.asList(collection), mapper);
        if (set == null) {
            ContainerUtilRt.$$$reportNull$$$0(81);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(82);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(83);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtilRt.$$$reportNull$$$0(84);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(85);
        }
        return hashSet;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<? extends V> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtilRt.$$$reportNull$$$0(92);
        }
        if (condition == null) {
            ContainerUtilRt.$$$reportNull$$$0(93);
        }
        return ContainerUtilRt.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<? extends V> iterator2, @NotNull Condition<? super T> condition) {
        if (iterator2 == null) {
            ContainerUtilRt.$$$reportNull$$$0(94);
        }
        if (condition == null) {
            ContainerUtilRt.$$$reportNull$$$0(95);
        }
        while (iterator2.hasNext()) {
            V value = iterator2.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtilRt";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 33: 
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 32: 
            case 68: 
            case 72: 
            case 79: 
            case 82: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 42: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 65: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 66: 
            case 73: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 93: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtilRt";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeMap";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayListWithCapacity";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 44: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 50: 
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeSet";
                break;
            }
            case 56: 
            case 58: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "newStack";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCOWList";
                break;
            }
            case 67: 
            case 74: 
            case 75: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 81: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 88: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 37: 
            case 39: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 51: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "newTreeSet";
                break;
            }
            case 57: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "newStack";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 65: 
            case 66: 
            case 72: 
            case 73: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 79: 
            case 80: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 86: 
            case 87: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList<T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index2) {
            throw new IndexOutOfBoundsException("Index: " + index2);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                EmptyList.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <E> E[] toArray(@NotNull E[] a) {
            if (a == null) {
                EmptyList.$$$reportNull$$$0(1);
            }
            if (a.length != 0) {
                a[0] = null;
            }
            if (a == null) {
                EmptyList.$$$reportNull$$$0(2);
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                EmptyList.$$$reportNull$$$0(3);
            }
            return emptyIterator;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            EmptyListIterator emptyListIterator = EmptyListIterator.getInstance();
            if (emptyListIterator == null) {
                EmptyList.$$$reportNull$$$0(4);
            }
            return emptyListIterator;
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            if (c == null) {
                EmptyList.$$$reportNull$$$0(5);
            }
            return c.isEmpty();
        }

        @Override
        @Contract(pure=true)
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Contract(pure=true)
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtilRt$EmptyList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtilRt$EmptyList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "containsAll";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

