/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0012"}, d2={"equalsDslDescriptor", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "dslName", "Lorg/jetbrains/kotlin/name/Name;", "firstArgumentAsExpressionOrNull", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isCallsInPlaceEffectDescriptor", "isContractCallDescriptor", "isEffectDescriptor", "isEqualsDescriptor", "isFromContractDsl", "isImpliesCallDescriptor", "isInvocationKindEnum", "isReturnsEffectDescriptor", "isReturnsNotNullDescriptor", "isReturnsWildcardDescriptor", "frontend"})
public final class PsiContractsUtilsKt {
    public static final boolean isFromContractDsl(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getAnnotations().hasAnnotation(ContractsDslNames.INSTANCE.getCONTRACTS_DSL_ANNOTATION_FQN());
    }

    public static final boolean isContractCallDescriptor(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiContractsUtilsKt.equalsDslDescriptor($receiver, ContractsDslNames.INSTANCE.getCONTRACT());
    }

    public static final boolean isImpliesCallDescriptor(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiContractsUtilsKt.equalsDslDescriptor($receiver, ContractsDslNames.INSTANCE.getIMPLIES());
    }

    public static final boolean isReturnsEffectDescriptor(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiContractsUtilsKt.equalsDslDescriptor($receiver, ContractsDslNames.INSTANCE.getRETURNS());
    }

    public static final boolean isReturnsNotNullDescriptor(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiContractsUtilsKt.equalsDslDescriptor($receiver, ContractsDslNames.INSTANCE.getRETURNS_NOT_NULL());
    }

    public static final boolean isReturnsWildcardDescriptor(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiContractsUtilsKt.equalsDslDescriptor($receiver, ContractsDslNames.INSTANCE.getRETURNS()) && $receiver instanceof FunctionDescriptor && ((FunctionDescriptor)$receiver).getValueParameters().isEmpty();
    }

    public static final boolean isEffectDescriptor(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiContractsUtilsKt.equalsDslDescriptor($receiver, ContractsDslNames.INSTANCE.getEFFECT());
    }

    public static final boolean isCallsInPlaceEffectDescriptor(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiContractsUtilsKt.equalsDslDescriptor($receiver, ContractsDslNames.INSTANCE.getCALLS_IN_PLACE());
    }

    public static final boolean isInvocationKindEnum(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PsiContractsUtilsKt.equalsDslDescriptor($receiver, ContractsDslNames.INSTANCE.getINVOCATION_KIND_ENUM());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEqualsDescriptor(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!($receiver instanceof FunctionDescriptor)) return false;
        if (!Intrinsics.areEqual((Object)((FunctionDescriptor)$receiver).getName(), (Object)Name.identifier("equals"))) return false;
        if (((FunctionDescriptor)$receiver).getDispatchReceiverParameter() == null) return false;
        KotlinType kotlinType2 = ((FunctionDescriptor)$receiver).getReturnType();
        if (kotlinType2 == null) return false;
        if (!TypeUtilsKt.isBoolean(kotlinType2)) return false;
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)$receiver).getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"this.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list2);
        Annotated annotated = valueParameterDescriptor;
        if (valueParameterDescriptor == null) return false;
        KotlinType kotlinType3 = annotated.getType();
        annotated = kotlinType3;
        if (kotlinType3 == null) return false;
        if (!TypeUtilsKt.isNullableAny((KotlinType)annotated)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final KtExpression firstArgumentAsExpressionOrNull(@NotNull ResolvedCall<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        List<ResolvedValueArgument> list2 = $receiver.getValueArgumentsByIndex();
        Object object = list2;
        if (list2 == null) return null;
        ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)CollectionsKt.firstOrNull(object);
        object = resolvedValueArgument;
        if (resolvedValueArgument == null) return null;
        Object $receiver$iv = object;
        Object object2 = $receiver$iv;
        if (!(object2 instanceof ExpressionValueArgument)) {
            object2 = null;
        }
        ExpressionValueArgument expressionValueArgument = (ExpressionValueArgument)object2;
        object = expressionValueArgument;
        if (expressionValueArgument == null) return null;
        ValueArgument valueArgument = ((ExpressionValueArgument)object).getValueArgument();
        object = valueArgument;
        if (valueArgument == null) return null;
        KtExpression ktExpression = object.getArgumentExpression();
        return ktExpression;
    }

    private static final boolean equalsDslDescriptor(@NotNull DeclarationDescriptor $receiver, Name dslName) {
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)dslName) && PsiContractsUtilsKt.isFromContractDsl($receiver);
    }
}

