/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.DescriptorAwareStringTable;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "", "stringTable", "Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;", "(Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;)V", "serializeAnnotation", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "valueProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "serialization"})
public final class AnnotationSerializer {
    private final DescriptorAwareStringTable stringTable;

    @NotNull
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationDescriptor annotation2) {
        ProtoBuf.Annotation.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)annotation2, (String)"annotation");
        ProtoBuf.Annotation.Builder $receiver = builder = ProtoBuf.Annotation.newBuilder();
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getAnnotationClass(annotation2);
        if (classDescriptor2 == null) {
            String string = "Annotation type is not a class: " + annotation2.getType();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ClassDescriptor annotationClass = classDescriptor2;
        if (ErrorUtils.isError(annotationClass)) {
            String string = "Unresolved annotation type: " + annotation2.getType() + " at " + annotation2.getSource().getContainingFile();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        $receiver.setId(this.stringTable.getFqNameIndex(annotationClass));
        Map<Name, ConstantValue<?>> map2 = annotation2.getAllValueArguments();
        Iterator<Map.Entry<Name, ConstantValue<?>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            ProtoBuf.Annotation.Argument.Builder argument;
            Map.Entry<Name, ConstantValue<?>> entry;
            Map.Entry<Name, ConstantValue<?>> entry2 = entry = iterator2.next();
            Name name = entry2.getKey();
            entry2 = entry;
            ConstantValue<?> value = entry2.getValue();
            ProtoBuf.Annotation.Argument.Builder builder2 = argument = ProtoBuf.Annotation.Argument.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"argument");
            String string = name.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
            builder2.setNameId(this.stringTable.getStringIndex(string));
            argument.setValue(this.valueProto(value));
            $receiver.addArgument(argument);
        }
        ProtoBuf.Annotation annotation3 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"ProtoBuf.Annotation.newB\u2026)\n        }\n    }.build()");
        return annotation3;
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto(@NotNull ConstantValue<?> constant) {
        ProtoBuf.Annotation.Argument.Value.Builder builder;
        Intrinsics.checkParameterIsNotNull(constant, (String)"constant");
        ProtoBuf.Annotation.Argument.Value.Builder $receiver = builder = ProtoBuf.Annotation.Argument.Value.newBuilder();
        constant.accept(new AnnotationArgumentVisitor<Unit, Unit>($receiver, this, constant){
            final /* synthetic */ ProtoBuf.Annotation.Argument.Value.Builder $this_apply;
            final /* synthetic */ AnnotationSerializer this$0;
            final /* synthetic */ ConstantValue $constant$inlined;
            {
                this.$this_apply = $receiver;
                this.this$0 = annotationSerializer2;
                this.$constant$inlined = constantValue;
            }

            public void visitAnnotationValue(@NotNull AnnotationValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
                this.$this_apply.setAnnotation(this.this$0.serializeAnnotation((AnnotationDescriptor)value.getValue()));
            }

            public void visitArrayValue(@NotNull ArrayValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
                for (ConstantValue element : (List)value.getValue()) {
                    this.$this_apply.addArrayElement(this.this$0.valueProto(element).build());
                }
            }

            public void visitBooleanValue(@NotNull BooleanValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
                this.$this_apply.setIntValue((Boolean)value.getValue() != false ? 1L : 0L);
            }

            public void visitByteValue(@NotNull ByteValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue(((Number)value.getValue()).byteValue());
            }

            public void visitCharValue(@NotNull CharValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
                this.$this_apply.setIntValue(((Character)value.getValue()).charValue());
            }

            public void visitDoubleValue(@NotNull DoubleValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
                this.$this_apply.setDoubleValue(((Number)value.getValue()).doubleValue());
            }

            public void visitEnumValue(@NotNull EnumValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
                this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(value.getEnumClassId()));
                DescriptorAwareStringTable descriptorAwareStringTable = AnnotationSerializer.access$getStringTable$p(this.this$0);
                String string = value.getEnumEntryName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.enumEntryName.asString()");
                this.$this_apply.setEnumValueId(descriptorAwareStringTable.getStringIndex(string));
            }

            public void visitErrorValue(@NotNull ErrorValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                throw (Throwable)new UnsupportedOperationException("Error value: " + value);
            }

            public void visitFloatValue(@NotNull FloatValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
                this.$this_apply.setFloatValue(((Number)value.getValue()).floatValue());
            }

            public void visitIntValue(@NotNull IntValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue(((Number)value.getValue()).intValue());
            }

            public void visitKClassValue(@NotNull KClassValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
                this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(value.getClassId()));
                if (value.getArrayDimensions() > 0) {
                    this.$this_apply.setArrayDimensionCount(value.getArrayDimensions());
                }
            }

            public void visitLongValue(@NotNull LongValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value.getValue()).longValue());
            }

            public void visitNullValue(@NotNull NullValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                throw (Throwable)new UnsupportedOperationException("Null should not appear in annotation arguments");
            }

            public void visitShortValue(@NotNull ShortValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue(((Number)value.getValue()).shortValue());
            }

            public void visitStringValue(@NotNull StringValue value, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
                this.$this_apply.setStringValue(AnnotationSerializer.access$getStringTable$p(this.this$0).getStringIndex((String)value.getValue()));
            }

            public void visitUByteValue(@NotNull UByteValue value, @Nullable Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue(((Number)value.getValue()).byteValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitUShortValue(@NotNull UShortValue value, @Nullable Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue(((Number)value.getValue()).shortValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitUIntValue(@NotNull UIntValue value, @Nullable Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue(((Number)value.getValue()).intValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitULongValue(@NotNull ULongValue value, @Nullable Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value.getValue()).longValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }
        }, Unit.INSTANCE);
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"Value.newBuilder().apply\u2026 }\n        }, Unit)\n    }");
        return builder2;
    }

    public AnnotationSerializer(@NotNull DescriptorAwareStringTable stringTable) {
        Intrinsics.checkParameterIsNotNull((Object)stringTable, (String)"stringTable");
        this.stringTable = stringTable;
    }

    public static final /* synthetic */ DescriptorAwareStringTable access$getStringTable$p(AnnotationSerializer $this) {
        return $this.stringTable;
    }
}

