/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.AsmBackedClassGenerator;
import org.gradle.internal.instantiation.ClassGenerator;
import org.gradle.internal.instantiation.DefaultInstantiationScheme;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.Jsr330ConstructorSelector;
import org.gradle.internal.instantiation.ParamsMatchingConstructorSelector;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultInstantiatorFactory
implements InstantiatorFactory {
    private final ServiceRegistry defaultServices;
    private final CrossBuildInMemoryCacheFactory cacheFactory;
    private final List<InjectAnnotationHandler> annotationHandlers;
    private final DefaultInstantiationScheme injectOnlyScheme;
    private final DefaultInstantiationScheme injectOnlyLenientScheme;
    private final DefaultInstantiationScheme decoratingScheme;
    private final DefaultInstantiationScheme decoratingLenientScheme;

    public DefaultInstantiatorFactory(CrossBuildInMemoryCacheFactory cacheFactory, List<InjectAnnotationHandler> annotationHandlers) {
        this.cacheFactory = cacheFactory;
        this.annotationHandlers = annotationHandlers;
        DefaultServiceRegistry services = new DefaultServiceRegistry();
        services.add(InstantiatorFactory.class, (Object)this);
        this.defaultServices = services;
        ClassGenerator injectOnly = AsmBackedClassGenerator.injectOnly(annotationHandlers, (Collection<Class<? extends Annotation>>)ImmutableSet.of());
        ClassGenerator decorated = AsmBackedClassGenerator.decorateAndInject(annotationHandlers, (Collection<Class<? extends Annotation>>)ImmutableSet.of());
        Jsr330ConstructorSelector injectOnlyJsr330Selector = new Jsr330ConstructorSelector(injectOnly, cacheFactory.newClassCache());
        Jsr330ConstructorSelector decoratedJsr330Selector = new Jsr330ConstructorSelector(decorated, cacheFactory.newClassCache());
        ParamsMatchingConstructorSelector injectOnlyLenientSelector = new ParamsMatchingConstructorSelector(injectOnly, cacheFactory.newClassCache());
        ParamsMatchingConstructorSelector decoratedLenientSelector = new ParamsMatchingConstructorSelector(decorated, cacheFactory.newClassCache());
        this.injectOnlyScheme = new DefaultInstantiationScheme(injectOnlyJsr330Selector, this.defaultServices, (Set<Class<? extends Annotation>>)ImmutableSet.of(Inject.class));
        this.injectOnlyLenientScheme = new DefaultInstantiationScheme(injectOnlyLenientSelector, this.defaultServices, (Set<Class<? extends Annotation>>)ImmutableSet.of(Inject.class));
        this.decoratingScheme = new DefaultInstantiationScheme(decoratedJsr330Selector, this.defaultServices, (Set<Class<? extends Annotation>>)ImmutableSet.of(Inject.class));
        this.decoratingLenientScheme = new DefaultInstantiationScheme(decoratedLenientSelector, this.defaultServices, (Set<Class<? extends Annotation>>)ImmutableSet.of(Inject.class));
    }

    @Override
    public Instantiator inject(ServiceLookup services) {
        return this.injectOnlyScheme.withServices(services);
    }

    @Override
    public Instantiator inject() {
        return this.injectOnlyScheme.instantiator();
    }

    @Override
    public InstantiationScheme injectScheme() {
        return this.injectOnlyScheme;
    }

    @Override
    public InstantiationScheme injectScheme(Collection<Class<? extends Annotation>> injectAnnotations) {
        if (injectAnnotations.isEmpty()) {
            return this.injectOnlyScheme;
        }
        for (Class<? extends Annotation> annotation : injectAnnotations) {
            this.assertKnownAnnotation(annotation);
        }
        ClassGenerator classGenerator = AsmBackedClassGenerator.injectOnly(this.annotationHandlers, (Collection<Class<? extends Annotation>>)ImmutableSet.copyOf(injectAnnotations));
        Jsr330ConstructorSelector constructorSelector = new Jsr330ConstructorSelector(classGenerator, this.cacheFactory.newClassCache());
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)(injectAnnotations.size() + 1));
        builder.addAll(injectAnnotations);
        builder.add(Inject.class);
        return new DefaultInstantiationScheme(constructorSelector, this.defaultServices, (Set<Class<? extends Annotation>>)builder.build());
    }

    @Override
    public Instantiator injectLenient() {
        return this.injectOnlyLenientScheme.instantiator();
    }

    @Override
    public Instantiator injectLenient(ServiceLookup services) {
        return this.injectOnlyLenientScheme.withServices(services);
    }

    @Override
    public Instantiator decorateLenient() {
        return this.decoratingLenientScheme.instantiator();
    }

    @Override
    public Instantiator injectAndDecorateLenient(ServiceLookup services) {
        return this.decoratingLenientScheme.withServices(services);
    }

    @Override
    public InstantiationScheme decorateScheme() {
        return this.decoratingScheme;
    }

    @Override
    public Instantiator injectAndDecorate(ServiceLookup services) {
        return this.decoratingScheme.withServices(services);
    }

    private void assertKnownAnnotation(Class<? extends Annotation> annotation) {
        for (InjectAnnotationHandler annotationHandler : this.annotationHandlers) {
            if (!annotationHandler.getAnnotationType().equals(annotation)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Annotation @%s is not a registered injection annotation.", annotation.getSimpleName()));
    }
}

