/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyVisitor;

public class IdeDependencySet {
    private final DependencyHandler dependencyHandler;
    private final Collection<Configuration> plusConfigurations;
    private final Collection<Configuration> minusConfigurations;
    private static final Spec<ComponentIdentifier> NOT_A_MODULE = new Spec<ComponentIdentifier>(){

        public boolean isSatisfiedBy(ComponentIdentifier id) {
            return !(id instanceof ModuleComponentIdentifier);
        }
    };

    public IdeDependencySet(DependencyHandler dependencyHandler, Collection<Configuration> plusConfigurations, Collection<Configuration> minusConfigurations) {
        this.dependencyHandler = dependencyHandler;
        this.plusConfigurations = plusConfigurations;
        this.minusConfigurations = minusConfigurations;
    }

    public void visit(IdeDependencyVisitor visitor) {
        if (this.plusConfigurations.isEmpty()) {
            return;
        }
        new IdeDependencyResult().visit(visitor);
    }

    private class IdeDependencyResult {
        private final Map<ComponentArtifactIdentifier, ResolvedArtifactResult> resolvedArtifacts = Maps.newLinkedHashMap();
        private final Map<ComponentSelector, UnresolvedDependencyResult> unresolvedDependencies = Maps.newLinkedHashMap();
        private final Table<ModuleComponentIdentifier, Class<? extends Artifact>, Set<ResolvedArtifactResult>> auxiliaryArtifacts = HashBasedTable.create();

        private IdeDependencyResult() {
        }

        public void visit(IdeDependencyVisitor visitor) {
            this.resolvePlusConfigurations(visitor);
            this.resolveMinusConfigurations(visitor);
            this.resolveAuxiliaryArtifacts(visitor);
            this.visitArtifacts(visitor);
            this.visitUnresolvedDependencies(visitor);
        }

        private void resolvePlusConfigurations(IdeDependencyVisitor visitor) {
            for (Configuration configuration : IdeDependencySet.this.plusConfigurations) {
                ArtifactCollection artifacts = this.getResolvedArtifacts(configuration, visitor);
                for (ResolvedArtifactResult resolvedArtifact : artifacts) {
                    this.resolvedArtifacts.put(resolvedArtifact.getId(), resolvedArtifact);
                }
                if (artifacts.getFailures().isEmpty()) continue;
                for (UnresolvedDependencyResult unresolvedDependency : this.getUnresolvedDependencies(configuration, visitor)) {
                    this.unresolvedDependencies.put(unresolvedDependency.getAttempted(), unresolvedDependency);
                }
            }
        }

        private void resolveMinusConfigurations(IdeDependencyVisitor visitor) {
            for (Configuration configuration : IdeDependencySet.this.minusConfigurations) {
                ArtifactCollection artifacts = this.getResolvedArtifacts(configuration, visitor);
                for (ResolvedArtifactResult resolvedArtifact : artifacts) {
                    this.resolvedArtifacts.remove(resolvedArtifact.getId());
                }
                if (artifacts.getFailures().isEmpty()) continue;
                for (UnresolvedDependencyResult unresolvedDependency : this.getUnresolvedDependencies(configuration, visitor)) {
                    this.unresolvedDependencies.remove(unresolvedDependency.getAttempted());
                }
            }
        }

        private ArtifactCollection getResolvedArtifacts(Configuration configuration, final IdeDependencyVisitor visitor) {
            return configuration.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(){

                public void execute(ArtifactView.ViewConfiguration viewConfiguration) {
                    viewConfiguration.lenient(true);
                    viewConfiguration.componentFilter(IdeDependencyResult.this.getComponentFilter(visitor));
                }
            }).getArtifacts();
        }

        private Spec<ComponentIdentifier> getComponentFilter(IdeDependencyVisitor visitor) {
            return visitor.isOffline() ? NOT_A_MODULE : Specs.satisfyAll();
        }

        private Iterable<UnresolvedDependencyResult> getUnresolvedDependencies(Configuration configuration, IdeDependencyVisitor visitor) {
            if (visitor.isOffline()) {
                return Collections.emptySet();
            }
            return Iterables.filter((Iterable)configuration.getIncoming().getResolutionResult().getRoot().getDependencies(), UnresolvedDependencyResult.class);
        }

        private void resolveAuxiliaryArtifacts(IdeDependencyVisitor visitor) {
            if (visitor.isOffline()) {
                return;
            }
            Set<ModuleComponentIdentifier> componentIdentifiers = this.getModuleComponentIdentifiers();
            if (componentIdentifiers.isEmpty()) {
                return;
            }
            List<Class<? extends Artifact>> types = this.getAuxiliaryArtifactTypes(visitor);
            if (types.isEmpty()) {
                return;
            }
            ArtifactResolutionResult result = IdeDependencySet.this.dependencyHandler.createArtifactResolutionQuery().forComponents(componentIdentifiers).withArtifacts(JvmLibrary.class, types).execute();
            for (ComponentArtifactsResult artifactsResult : result.getResolvedComponents()) {
                for (Class<? extends Artifact> type : types) {
                    LinkedHashSet resolvedArtifactResults = Sets.newLinkedHashSet();
                    for (ArtifactResult artifactResult : artifactsResult.getArtifacts(type)) {
                        if (!(artifactResult instanceof ResolvedArtifactResult)) continue;
                        resolvedArtifactResults.add((ResolvedArtifactResult)artifactResult);
                    }
                    this.auxiliaryArtifacts.put((Object)((ModuleComponentIdentifier)artifactsResult.getId()), type, (Object)resolvedArtifactResults);
                }
            }
        }

        private Set<ModuleComponentIdentifier> getModuleComponentIdentifiers() {
            LinkedHashSet componentIdentifiers = Sets.newLinkedHashSet();
            for (ComponentArtifactIdentifier identifier : this.resolvedArtifacts.keySet()) {
                ComponentIdentifier componentIdentifier = identifier.getComponentIdentifier();
                if (!(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
                componentIdentifiers.add((ModuleComponentIdentifier)componentIdentifier);
            }
            return componentIdentifiers;
        }

        private List<Class<? extends Artifact>> getAuxiliaryArtifactTypes(IdeDependencyVisitor visitor) {
            ArrayList types = Lists.newArrayListWithCapacity((int)2);
            if (visitor.downloadSources()) {
                types.add(SourcesArtifact.class);
            }
            if (visitor.downloadJavaDoc()) {
                types.add(JavadocArtifact.class);
            }
            return types;
        }

        private void visitArtifacts(IdeDependencyVisitor visitor) {
            for (ResolvedArtifactResult artifact : this.resolvedArtifacts.values()) {
                ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
                if (componentIdentifier instanceof ProjectComponentIdentifier) {
                    visitor.visitProjectDependency(artifact);
                    continue;
                }
                if (componentIdentifier instanceof ModuleComponentIdentifier) {
                    Set<ResolvedArtifactResult> sources = (Set<ResolvedArtifactResult>)this.auxiliaryArtifacts.get((Object)componentIdentifier, SourcesArtifact.class);
                    sources = sources != null ? sources : Collections.emptySet();
                    Set<ResolvedArtifactResult> javaDoc = (Set<ResolvedArtifactResult>)this.auxiliaryArtifacts.get((Object)componentIdentifier, JavadocArtifact.class);
                    javaDoc = javaDoc != null ? javaDoc : Collections.emptySet();
                    visitor.visitModuleDependency(artifact, sources, javaDoc);
                    continue;
                }
                visitor.visitFileDependency(artifact);
            }
        }

        private void visitUnresolvedDependencies(IdeDependencyVisitor visitor) {
            for (UnresolvedDependencyResult unresolvedDependency : this.unresolvedDependencies.values()) {
                visitor.visitUnresolvedDependency(unresolvedDependency);
            }
        }
    }
}

