/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.reflect.Instantiator;

public class PropertyAssociationTaskFactory
implements ITaskFactory {
    private final ITaskFactory delegate;
    private final PropertyWalker propertyWalker;

    public PropertyAssociationTaskFactory(ITaskFactory delegate, PropertyWalker propertyWalker) {
        this.delegate = delegate;
        this.propertyWalker = propertyWalker;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new PropertyAssociationTaskFactory(this.delegate.createChild(project, instantiator), this.propertyWalker);
    }

    @Override
    public <S extends Task> S create(TaskIdentity<S> taskIdentity, Object ... args) {
        S task = this.delegate.create(taskIdentity, args);
        TaskPropertyUtils.visitProperties(this.propertyWalker, (TaskInternal)task, new Listener((Task)task));
        return task;
    }

    private static class Listener
    implements PropertyVisitor {
        private final Task task;

        public Listener(Task task) {
            this.task = task;
        }

        @Override
        public boolean visitOutputFilePropertiesOnly() {
            return true;
        }

        @Override
        public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitInputProperty(String propertyName, PropertyValue value, boolean optional) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitDestroyableProperty(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitLocalStateProperty(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
            value.attachProducer(this.task);
        }
    }
}

