/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.IncompatibleConfigurationSelectionException;
import org.gradle.internal.component.model.AttributeConfigurationSelector;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.exceptions.ConfigurationNotConsumableException;
import org.gradle.util.GUtil;

public class LocalComponentDependencyMetadata
implements LocalOriginDependencyMetadata {
    private final ComponentIdentifier componentId;
    private final ComponentSelector selector;
    private final String moduleConfiguration;
    private final String dependencyConfiguration;
    private final List<ExcludeMetadata> excludes;
    private final List<IvyArtifactName> artifactNames;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final boolean constraint;
    private final boolean fromLock;
    private final String reason;
    private final AttributeContainer moduleAttributes;
    private final ImmutableAttributes dependencyAttributes;

    public LocalComponentDependencyMetadata(ComponentIdentifier componentId, ComponentSelector selector, String moduleConfiguration, AttributeContainer moduleAttributes, AttributeContainer dependencyAttributes, String dependencyConfiguration, List<IvyArtifactName> artifactNames, List<ExcludeMetadata> excludes, boolean force, boolean changing, boolean transitive, boolean constraint, String reason) {
        this(componentId, selector, moduleConfiguration, moduleAttributes, dependencyAttributes, dependencyConfiguration, artifactNames, excludes, force, changing, transitive, constraint, false, reason);
    }

    public LocalComponentDependencyMetadata(ComponentIdentifier componentId, ComponentSelector selector, String moduleConfiguration, AttributeContainer moduleAttributes, AttributeContainer dependencyAttributes, String dependencyConfiguration, List<IvyArtifactName> artifactNames, List<ExcludeMetadata> excludes, boolean force, boolean changing, boolean transitive, boolean constraint, boolean fromLock, String reason) {
        this.componentId = componentId;
        this.selector = selector;
        this.moduleConfiguration = moduleConfiguration;
        this.moduleAttributes = moduleAttributes;
        this.dependencyAttributes = ((AttributeContainerInternal)dependencyAttributes).asImmutable();
        this.dependencyConfiguration = dependencyConfiguration;
        this.artifactNames = LocalComponentDependencyMetadata.asImmutable(artifactNames);
        this.excludes = excludes;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
        this.constraint = constraint;
        this.fromLock = fromLock;
        this.reason = reason;
    }

    private static List<IvyArtifactName> asImmutable(List<IvyArtifactName> artifactNames) {
        return artifactNames.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(artifactNames);
    }

    public String toString() {
        return "dependency: " + this.selector + " from-conf: " + this.moduleConfiguration + " to-conf: " + this.dependencyConfiguration;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public String getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    @Override
    public String getDependencyConfiguration() {
        return LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.dependencyConfiguration);
    }

    private static String getOrDefaultConfiguration(String configuration) {
        return (String)GUtil.elvis((Object)configuration, (Object)"default");
    }

    @Override
    public List<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema, Collection<? extends Capability> explicitRequestedCapabilities) {
        AttributesSchemaInternal producerAttributeSchema;
        boolean useConfigurationAttributes;
        boolean consumerHasAttributes = !consumerAttributes.isEmpty();
        Optional<ImmutableList<? extends ConfigurationMetadata>> targetVariants = targetComponent.getVariantsForGraphTraversal();
        boolean bl = useConfigurationAttributes = this.dependencyConfiguration == null && (consumerHasAttributes || targetVariants.isPresent());
        if (useConfigurationAttributes) {
            return ImmutableList.of((Object)AttributeConfigurationSelector.selectConfigurationUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponent, consumerSchema, this.getArtifacts()));
        }
        String targetConfiguration = (String)GUtil.elvis((Object)this.dependencyConfiguration, (Object)"default");
        ConfigurationMetadata toConfiguration = targetComponent.getConfiguration(targetConfiguration);
        if (toConfiguration == null) {
            throw new ConfigurationNotFoundException(this.componentId, this.moduleConfiguration, targetConfiguration, targetComponent.getId());
        }
        if (!toConfiguration.isCanBeConsumed()) {
            throw new ConfigurationNotConsumableException(targetComponent.toString(), toConfiguration.getName());
        }
        if (consumerHasAttributes && !toConfiguration.getAttributes().isEmpty() && !consumerSchema.withProducer(producerAttributeSchema = targetComponent.getAttributesSchema()).isMatching((AttributeContainerInternal)toConfiguration.getAttributes(), (AttributeContainerInternal)consumerAttributes)) {
            throw new IncompatibleConfigurationSelectionException((AttributeContainerInternal)consumerAttributes, consumerSchema.withProducer(producerAttributeSchema), targetComponent, targetConfiguration, targetVariants.isPresent());
        }
        return ImmutableList.of((Object)toConfiguration);
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public boolean isConstraint() {
        return this.constraint;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.artifactNames;
    }

    @Override
    public LocalOriginDependencyMetadata withTarget(ComponentSelector target) {
        if (this.selector.equals(target)) {
            return this;
        }
        return this.copyWithTarget(target);
    }

    @Override
    public LocalOriginDependencyMetadata forced() {
        if (this.force) {
            return this;
        }
        return this.copyWithForce(true);
    }

    @Override
    public boolean isFromLock() {
        return this.fromLock;
    }

    @Override
    public DependencyMetadata withReason(String reason) {
        if (Objects.equal((Object)reason, (Object)this.reason)) {
            return this;
        }
        return this.copyWithReason(reason);
    }

    private LocalOriginDependencyMetadata copyWithTarget(ComponentSelector selector) {
        return new LocalComponentDependencyMetadata(this.componentId, selector, this.moduleConfiguration, this.moduleAttributes, (AttributeContainer)this.dependencyAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive, this.constraint, this.fromLock, this.reason);
    }

    private LocalOriginDependencyMetadata copyWithReason(String reason) {
        return new LocalComponentDependencyMetadata(this.componentId, this.selector, this.moduleConfiguration, this.moduleAttributes, (AttributeContainer)this.dependencyAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive, this.constraint, this.fromLock, reason);
    }

    private LocalOriginDependencyMetadata copyWithForce(boolean force) {
        return new LocalComponentDependencyMetadata(this.componentId, this.selector, this.moduleConfiguration, this.moduleAttributes, (AttributeContainer)this.dependencyAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, force, this.changing, this.transitive, this.constraint, this.fromLock, this.reason);
    }
}

