/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.base.Function;
import javax.annotation.Nullable;

public final class Pair<L, R> {
    @Nullable
    public final L left;
    @Nullable
    public final R right;

    private Pair(@Nullable L left, @Nullable R right) {
        this.left = left;
        this.right = right;
    }

    @Nullable
    public L getLeft() {
        return this.left;
    }

    @Nullable
    public R getRight() {
        return this.right;
    }

    @Nullable
    public L left() {
        return this.left;
    }

    @Nullable
    public R right() {
        return this.right;
    }

    public static <L, R> Pair<L, R> of(@Nullable L left, @Nullable R right) {
        return new Pair<L, R>(left, right);
    }

    public <T> Pair<T, Pair<L, R>> pushLeft(T t) {
        return Pair.of(t, this);
    }

    public <T> Pair<Pair<L, R>, T> pushRight(T t) {
        return Pair.of(this, t);
    }

    public <T> Pair<Pair<T, L>, R> nestLeft(T t) {
        return Pair.of(Pair.of(t, this.left), this.right);
    }

    public <T> Pair<L, Pair<T, R>> nestRight(T t) {
        return Pair.of(this.left, Pair.of(t, this.right));
    }

    public <T> Pair<T, R> mapLeft(Function<? super L, ? extends T> function) throws Exception {
        return Pair.of(function.apply(this.left), this.right);
    }

    public <T> Pair<L, T> mapRight(Function<? super R, ? extends T> function) throws Exception {
        return Pair.of(this.left, function.apply(this.right));
    }

    @Nullable
    public <T> T map(Function<? super Pair<L, R>, ? extends T> function) throws Exception {
        return (T)function.apply((Object)this);
    }

    public static <L, T extends Pair<L, ?>> Function<T, L> unpackLeft() {
        return new Function<T, L>(){

            public L apply(T tuple) {
                return ((Pair)tuple).left;
            }
        };
    }

    public static <R, T extends Pair<?, R>> Function<T, R> unpackRight() {
        return new Function<T, R>(){

            public R apply(T tuple) {
                return ((Pair)tuple).right;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return !(this.left == null ? pair.left != null : !this.left.equals(pair.left)) && !(this.right == null ? pair.right != null : !this.right.equals(pair.right));
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair[" + this.left + "," + this.right + ']';
    }
}

