/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.IncrementalInputsTaskAction;
import org.gradle.api.internal.project.taskfactory.IncrementalTaskInputsTaskAction;
import org.gradle.api.internal.tasks.InputChangesAwareTaskAction;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationResult;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskActionBuildOperationType;
import org.gradle.api.internal.tasks.execution.TaskCacheabilityResolver;
import org.gradle.api.internal.tasks.execution.TaskSnapshotter;
import org.gradle.api.internal.tasks.properties.CacheableOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.execution.AfterPreviousExecutionContext;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.impl.OutputFilterUtil;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.ExecutingBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.work.AsyncWorkTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteActionsTaskExecuter.class);
    private final boolean buildCacheEnabled;
    private final boolean scanPluginApplied;
    private final TaskSnapshotter taskSnapshotter;
    private final ExecutionHistoryStore executionHistoryStore;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final TaskActionListener actionListener;
    private final TaskCacheabilityResolver taskCacheabilityResolver;
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final WorkExecutor<AfterPreviousExecutionContext, CachingResult> workExecutor;
    private final ListenerManager listenerManager;

    public ExecuteActionsTaskExecuter(boolean buildCacheEnabled, boolean scanPluginApplied, TaskSnapshotter taskSnapshotter, ExecutionHistoryStore executionHistoryStore, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, TaskActionListener actionListener, TaskCacheabilityResolver taskCacheabilityResolver, FileCollectionFingerprinterRegistry fingerprinterRegistry, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, WorkExecutor<AfterPreviousExecutionContext, CachingResult> workExecutor, ListenerManager listenerManager) {
        this.buildCacheEnabled = buildCacheEnabled;
        this.scanPluginApplied = scanPluginApplied;
        this.taskSnapshotter = taskSnapshotter;
        this.executionHistoryStore = executionHistoryStore;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.actionListener = actionListener;
        this.taskCacheabilityResolver = taskCacheabilityResolver;
        this.fingerprinterRegistry = fingerprinterRegistry;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.workExecutor = workExecutor;
        this.listenerManager = listenerManager;
    }

    @Override
    public TaskExecuterResult execute(final TaskInternal task, final TaskStateInternal state, final TaskExecutionContext context) {
        final TaskExecution work = new TaskExecution(task, context, this.executionHistoryStore, this.fingerprinterRegistry, this.classLoaderHierarchyHasher);
        final CachingResult result = (CachingResult)this.workExecutor.execute((Context)new AfterPreviousExecutionContext(){

            public UnitOfWork getWork() {
                return work;
            }

            public Optional<String> getRebuildReason() {
                return context.getTaskExecutionMode().getRebuildReason();
            }

            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return Optional.ofNullable(context.getAfterPreviousExecution());
            }
        });
        result.getOutcome().ifSuccessfulOrElse((Consumer)new Consumer<ExecutionOutcome>(){

            @Override
            public void accept(ExecutionOutcome outcome) {
                state.setOutcome(TaskExecutionOutcome.valueOf(outcome));
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable failure) {
                state.setOutcome((RuntimeException)((Object)new TaskExecutionException(task, failure)));
            }
        });
        return new TaskExecuterResult(){

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.isReused() ? Optional.of(result.getOriginMetadata()) : Optional.empty();
            }

            @Override
            public boolean executedIncrementally() {
                return (Boolean)result.getOutcome().map((Function)new Function<ExecutionOutcome, Boolean>(){

                    @Override
                    public Boolean apply(ExecutionOutcome executionOutcome) {
                        return executionOutcome == ExecutionOutcome.EXECUTED_INCREMENTALLY;
                    }
                }).orElseMapFailure((Function)new Function<Throwable, Boolean>(){

                    @Override
                    public Boolean apply(Throwable throwable) {
                        return false;
                    }
                });
            }

            @Override
            public List<String> getExecutionReasons() {
                return result.getExecutionReasons();
            }

            @Override
            public CachingState getCachingState() {
                return result.getCachingState();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeActions(TaskInternal task, @Nullable InputChangesInternal inputChanges) {
        boolean hasTaskListener = this.listenerManager.hasListeners(TaskActionListener.class) || this.listenerManager.hasListeners(TaskExecutionListener.class);
        Iterator<InputChangesAwareTaskAction> actions = new ArrayList<InputChangesAwareTaskAction>(task.getTaskActions()).iterator();
        while (actions.hasNext()) {
            InputChangesAwareTaskAction action = actions.next();
            task.getState().setDidWork(true);
            task.getStandardOutputCapture().start();
            boolean hasMoreWork = hasTaskListener || actions.hasNext();
            try {
                this.executeAction(action.getDisplayName(), task, action, inputChanges, hasMoreWork);
            }
            catch (StopActionException e) {
                LOGGER.debug("Action stopped by some action with message: {}", (Object)e.getMessage());
            }
            catch (StopExecutionException e) {
                LOGGER.info("Execution stopped by some action with message: {}", (Object)e.getMessage());
                break;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
    }

    private void executeAction(final String actionDisplayName, final TaskInternal task, final InputChangesAwareTaskAction action, @Nullable InputChangesInternal inputChanges, final boolean hasMoreWork) {
        if (inputChanges != null) {
            action.setInputChanges(inputChanges);
        }
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)(actionDisplayName + " for " + task.getIdentityPath().getPath())).name(actionDisplayName).details((Object)ExecuteTaskActionBuildOperationType.DETAILS_INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(BuildOperationContext context) {
                try {
                    BuildOperationRef currentOperation = ExecuteActionsTaskExecuter.this.buildOperationExecutor.getCurrentOperation();
                    Throwable actionFailure = null;
                    try {
                        action.execute(task);
                    }
                    catch (Throwable t) {
                        actionFailure = t;
                    }
                    finally {
                        action.clearInputChanges();
                    }
                    try {
                        ExecuteActionsTaskExecuter.this.asyncWorkTracker.waitForCompletion(currentOperation, hasMoreWork ? AsyncWorkTracker.ProjectLockRetention.RELEASE_AND_REACQUIRE_PROJECT_LOCKS : AsyncWorkTracker.ProjectLockRetention.RELEASE_PROJECT_LOCKS);
                    }
                    catch (Throwable t) {
                        ArrayList failures = Lists.newArrayList();
                        if (actionFailure != null) {
                            failures.add(actionFailure);
                        }
                        if (t instanceof MultiCauseException) {
                            failures.addAll(((MultiCauseException)t).getCauses());
                        } else {
                            failures.add(t);
                        }
                        if (failures.size() > 1) {
                            throw new MultipleTaskActionFailures("Multiple task action failures occurred:", failures);
                        }
                        throw UncheckedException.throwAsUncheckedException((Throwable)((Throwable)failures.get(0)));
                    }
                    if (actionFailure != null) {
                        context.failed(actionFailure);
                        throw UncheckedException.throwAsUncheckedException((Throwable)actionFailure);
                    }
                }
                finally {
                    context.setResult((Object)ExecuteTaskActionBuildOperationType.RESULT_INSTANCE);
                }
            }
        });
    }

    @Contextual
    private static class MultipleTaskActionFailures
    extends DefaultMultiCauseException {
        public MultipleTaskActionFailures(String message, Iterable<? extends Throwable> causes) {
            super(message, causes);
        }
    }

    private class TaskExecution
    implements UnitOfWork {
        private final TaskInternal task;
        private final TaskExecutionContext context;
        private final ExecutionHistoryStore executionHistoryStore;
        private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;

        public TaskExecution(TaskInternal task, TaskExecutionContext context, ExecutionHistoryStore executionHistoryStore, FileCollectionFingerprinterRegistry fingerprinterRegistry, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
            this.task = task;
            this.context = context;
            this.executionHistoryStore = executionHistoryStore;
            this.fingerprinterRegistry = fingerprinterRegistry;
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        }

        public String getIdentity() {
            return this.task.getPath();
        }

        public UnitOfWork.WorkResult execute(@Nullable InputChangesInternal inputChanges) {
            this.task.getState().setExecuting(true);
            try {
                LOGGER.debug("Executing actions for {}.", (Object)this.task);
                ExecuteActionsTaskExecuter.this.actionListener.beforeActions((Task)this.task);
                ExecuteActionsTaskExecuter.this.executeActions(this.task, inputChanges);
                UnitOfWork.WorkResult workResult = this.task.getState().getDidWork() ? UnitOfWork.WorkResult.DID_WORK : UnitOfWork.WorkResult.DID_NO_WORK;
                return workResult;
            }
            finally {
                this.task.getState().setExecuting(false);
                ExecuteActionsTaskExecuter.this.actionListener.afterActions((Task)this.task);
            }
        }

        public ExecutionHistoryStore getExecutionHistoryStore() {
            return this.executionHistoryStore;
        }

        public void visitImplementations(UnitOfWork.ImplementationVisitor visitor) {
            visitor.visitImplementation(this.task.getClass());
            List<InputChangesAwareTaskAction> taskActions = this.task.getTaskActions();
            for (InputChangesAwareTaskAction taskAction : taskActions) {
                visitor.visitAdditionalImplementation(taskAction.getActionImplementation(this.classLoaderHierarchyHasher));
            }
        }

        public void visitInputProperties(UnitOfWork.InputPropertyVisitor visitor) {
            Map<String, Object> inputPropertyValues = this.context.getTaskProperties().getInputPropertyValues().get();
            for (Map.Entry<String, Object> entry : inputPropertyValues.entrySet()) {
                String propertyName = entry.getKey();
                Object value = entry.getValue();
                visitor.visitInputProperty(propertyName, value);
            }
        }

        public void visitInputFileProperties(UnitOfWork.InputFilePropertyVisitor visitor) {
            ImmutableSortedSet<InputFilePropertySpec> inputFileProperties = this.context.getTaskProperties().getInputFileProperties();
            for (InputFilePropertySpec inputFileProperty : inputFileProperties) {
                Object value = inputFileProperty.getValue();
                boolean incremental = inputFileProperty.isIncremental() || inputFileProperty.isSkipWhenEmpty();
                String propertyName = inputFileProperty.getPropertyName();
                visitor.visitInputFileProperty(propertyName, value, incremental, () -> {
                    FileCollectionFingerprinter fingerprinter = this.fingerprinterRegistry.getFingerprinter(inputFileProperty.getNormalizer());
                    return fingerprinter.fingerprint(inputFileProperty.getPropertyFiles());
                });
            }
        }

        public void visitOutputProperties(UnitOfWork.OutputPropertyVisitor visitor) {
            for (OutputFilePropertySpec property : this.context.getTaskProperties().getOutputFileProperties()) {
                visitor.visitOutputProperty(property.getPropertyName(), property.getOutputType(), property.getPropertyFiles());
            }
        }

        public void visitOutputTrees(CacheableEntity.CacheableTreeVisitor visitor) {
            for (OutputFilePropertySpec property : this.context.getTaskProperties().getOutputFileProperties()) {
                if (!(property instanceof CacheableOutputFilePropertySpec)) {
                    throw new IllegalStateException("Non-cacheable property: " + property);
                }
                File cacheRoot = ((CacheableOutputFilePropertySpec)property).getOutputFile();
                if (cacheRoot == null) continue;
                visitor.visitOutputTree(property.getPropertyName(), property.getOutputType(), cacheRoot);
            }
        }

        public void visitLocalState(UnitOfWork.LocalStateVisitor visitor) {
            for (File localStateFile : this.context.getTaskProperties().getLocalStateFiles()) {
                visitor.visitLocalStateRoot(localStateFile);
            }
        }

        public boolean hasOverlappingOutputs() {
            return this.context.getOverlappingOutputs().isPresent();
        }

        public boolean shouldCleanupOutputsOnNonIncrementalExecution() {
            return this.getInputChangeTrackingStrategy() == UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS;
        }

        public Optional<? extends Iterable<String>> getChangingOutputs() {
            return Optional.empty();
        }

        public Optional<CachingDisabledReason> shouldDisableCaching() {
            if (this.task.isHasCustomActions()) {
                LOGGER.info("Custom actions are attached to {}.", (Object)this.task);
            }
            return ExecuteActionsTaskExecuter.this.taskCacheabilityResolver.shouldDisableCaching(this.context.getTaskProperties().hasDeclaredOutputs(), this.context.getTaskProperties().getOutputFileProperties(), this.task, this.task.getOutputs().getCacheIfSpecs(), this.task.getOutputs().getDoNotCacheIfSpecs(), this.context.getOverlappingOutputs().orElse(null));
        }

        public boolean isTaskHistoryMaintained() {
            return this.context.getTaskExecutionMode().isTaskHistoryMaintained();
        }

        public boolean isAllowedToLoadFromCache() {
            return this.context.getTaskExecutionMode().isAllowedToUseCachedResults();
        }

        public Optional<Duration> getTimeout() {
            return Optional.ofNullable((Duration)this.task.getTimeout().getOrNull());
        }

        public UnitOfWork.InputChangeTrackingStrategy getInputChangeTrackingStrategy() {
            for (InputChangesAwareTaskAction taskAction : this.task.getTaskActions()) {
                if (taskAction instanceof IncrementalInputsTaskAction) {
                    return UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS;
                }
                if (!(taskAction instanceof IncrementalTaskInputsTaskAction)) continue;
                return UnitOfWork.InputChangeTrackingStrategy.ALL_PARAMETERS;
            }
            return UnitOfWork.InputChangeTrackingStrategy.NONE;
        }

        public ImmutableSortedMap<String, FileSystemSnapshot> getOutputFileSnapshotsBeforeExecution() {
            return this.context.getOutputFilesBeforeExecution();
        }

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterOutputsGenerated() {
            AfterPreviousExecutionState afterPreviousExecutionState = this.context.getAfterPreviousExecution();
            ImmutableSortedMap<String, FileSystemSnapshot> outputsAfterExecution = ExecuteActionsTaskExecuter.this.taskSnapshotter.snapshotTaskFiles(this.task, (SortedSet<? extends FilePropertySpec>)this.context.getTaskProperties().getOutputFileProperties());
            return this.createFilteredOutputFingerprints(afterPreviousExecutionState, this.context.getOutputFilesBeforeExecution(), outputsAfterExecution, this.context.getOverlappingOutputs().isPresent());
        }

        private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> createFilteredOutputFingerprints(@Nullable AfterPreviousExecutionState afterPreviousExecutionState, ImmutableSortedMap<String, FileSystemSnapshot> beforeExecutionOutputSnapshots, ImmutableSortedMap<String, FileSystemSnapshot> afterExecutionOutputSnapshots, boolean hasOverlappingOutputs) {
            ImmutableSortedMap afterLastExecutionFingerprints = afterPreviousExecutionState == null ? ImmutableSortedMap.of() : afterPreviousExecutionState.getOutputFileProperties();
            return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(afterExecutionOutputSnapshots, (propertyName, afterExecutionOutputSnapshot) -> {
                FileCollectionFingerprint afterLastExecutionFingerprint = (FileCollectionFingerprint)afterLastExecutionFingerprints.get(propertyName);
                FileSystemSnapshot beforeExecutionOutputSnapshot = (FileSystemSnapshot)beforeExecutionOutputSnapshots.get(propertyName);
                return this.fingerprintOutputSnapshot(afterLastExecutionFingerprint, beforeExecutionOutputSnapshot, (FileSystemSnapshot)afterExecutionOutputSnapshot, hasOverlappingOutputs);
            }));
        }

        private CurrentFileCollectionFingerprint fingerprintOutputSnapshot(@Nullable FileCollectionFingerprint afterLastExecutionFingerprint, FileSystemSnapshot beforeExecutionOutputSnapshot, FileSystemSnapshot afterExecutionOutputSnapshot, boolean hasOverlappingOutputs) {
            ImmutableList roots = hasOverlappingOutputs ? OutputFilterUtil.filterOutputSnapshotAfterExecution((FileCollectionFingerprint)afterLastExecutionFingerprint, (FileSystemSnapshot)beforeExecutionOutputSnapshot, (FileSystemSnapshot)afterExecutionOutputSnapshot) : ImmutableList.of((Object)afterExecutionOutputSnapshot);
            return DefaultCurrentFileCollectionFingerprint.from((Iterable)roots, (FingerprintingStrategy)AbsolutePathFingerprintingStrategy.IGNORE_MISSING);
        }

        public long markExecutionTime() {
            return this.context.markExecutionTime();
        }

        public void markSnapshottingInputsFinished(final CachingState cachingState) {
            if (ExecuteActionsTaskExecuter.this.buildCacheEnabled || ExecuteActionsTaskExecuter.this.scanPluginApplied) {
                this.context.removeSnapshotTaskInputsBuildOperation().ifPresent(new Consumer<ExecutingBuildOperation>(){

                    @Override
                    public void accept(ExecutingBuildOperation operation) {
                        operation.setResult((Object)new SnapshotTaskInputsBuildOperationResult(cachingState));
                    }
                });
            }
        }

        public String getDisplayName() {
            return this.task.toString();
        }
    }
}

