/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.util.GFileUtils;

@Incubating
public class InstallExecutable
extends DefaultTask {
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;
    private final DirectoryProperty installDirectory;
    private final RegularFileProperty executable;
    private final RegularFileProperty installedExecutable;
    private final ConfigurableFileCollection libs;
    private final WorkerLeaseService workerLeaseService;

    @Inject
    public InstallExecutable(WorkerLeaseService workerLeaseService) {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.workerLeaseService = workerLeaseService;
        this.libs = this.getProject().files(new Object[0]);
        this.installDirectory = objectFactory.directoryProperty();
        this.installedExecutable = objectFactory.fileProperty();
        this.executable = objectFactory.fileProperty();
        this.installedExecutable.set(this.getLibDirectory().map(directory -> directory.file(((File)this.executable.getAsFile().get()).getName())));
        this.getInputs().file((Object)this.executable);
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @OutputDirectory
    public DirectoryProperty getInstallDirectory() {
        return this.installDirectory;
    }

    @Internal(value="Covered by inputFileIfExists")
    public RegularFileProperty getExecutableFile() {
        return this.executable;
    }

    @OutputFile
    public RegularFileProperty getInstalledExecutable() {
        return this.installedExecutable;
    }

    @SkipWhenEmpty
    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFile
    protected File getInputFileIfExists() {
        RegularFileProperty sourceFile = this.getExecutableFile();
        if (sourceFile.isPresent() && ((RegularFile)sourceFile.get()).getAsFile().exists()) {
            return ((RegularFile)sourceFile.get()).getAsFile();
        }
        return null;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getLibs() {
        return this.libs;
    }

    public void setLibs(FileCollection libs) {
        this.libs.setFrom((Iterable)libs);
    }

    public void lib(Object libs) {
        this.libs.from(new Object[]{libs});
    }

    @Internal(value="covered by getInstallDirectory")
    public Provider<RegularFile> getRunScriptFile() {
        return this.installDirectory.file(this.executable.map(executableFile -> OperatingSystem.forName((String)((NativePlatform)this.targetPlatform.get()).getOperatingSystem().getName()).getScriptName(executableFile.getAsFile().getName())));
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void install() {
        NativePlatform nativePlatform = (NativePlatform)this.targetPlatform.get();
        File executable = ((RegularFile)this.getExecutableFile().get()).getAsFile();
        File libDirectory = ((Directory)this.getLibDirectory().get()).getAsFile();
        File runScript = ((RegularFile)this.getRunScriptFile().get()).getAsFile();
        Set libs = this.getLibs().getFiles();
        this.workerLeaseService.withoutProjectLock(() -> {
            this.installToDir(libDirectory, executable, libs);
            if (nativePlatform.getOperatingSystem().isWindows()) {
                this.installWindows(executable, runScript);
            } else {
                this.installUnix(executable, runScript);
            }
        });
    }

    private Provider<Directory> getLibDirectory() {
        return this.getInstallDirectory().dir("lib");
    }

    private void installWindows(File executable, File runScript) {
        StringBuilder toolChainPath = new StringBuilder();
        NativeToolChain toolChain = (NativeToolChain)this.getToolChain().get();
        if (toolChain instanceof Gcc) {
            toolChainPath.append("SET PATH=");
            for (File pathEntry : ((Gcc)toolChain).getPath()) {
                toolChainPath.append(pathEntry.getAbsolutePath()).append(";");
            }
            toolChainPath.append("%PATH%");
        }
        String runScriptText = "\n@echo off\nSETLOCAL\n" + toolChainPath + "\nCALL \"%~dp0lib\\" + executable.getName() + "\" %*\nEXIT /B %ERRORLEVEL%\nENDLOCAL\n";
        GFileUtils.writeFile((String)runScriptText, (File)runScript);
    }

    private void installUnix(File executable, File runScript) {
        String runScriptText = "#!/bin/sh\nAPP_BASE_NAME=`dirname \"$0\"`\nDYLD_LIBRARY_PATH=\"$APP_BASE_NAME/lib\"\nexport DYLD_LIBRARY_PATH\nLD_LIBRARY_PATH=\"$APP_BASE_NAME/lib\"\nexport LD_LIBRARY_PATH\nexec \"$APP_BASE_NAME/lib/" + executable.getName() + "\" \"$@\"\n";
        GFileUtils.writeFile((String)runScriptText, (File)runScript);
        this.getFileSystem().chmod(runScript, 493);
    }

    private void installToDir(File binaryDir, File executableFile, Collection<File> libs) {
        this.getFileOperations().sync(copySpec -> {
            copySpec.into((Object)binaryDir);
            copySpec.from(new Object[]{executableFile});
            copySpec.from(new Object[]{libs});
        });
    }
}

