/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import gnu.trove.TIntIntHashMap;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.SourceInfo;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.NestedSourceMapper;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/NestedSourceMapper;", "Lorg/jetbrains/kotlin/codegen/inline/DefaultSourceMapper;", "parent", "Lorg/jetbrains/kotlin/codegen/inline/SourceMapper;", "ranges", "", "Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "sourceInfo", "Lorg/jetbrains/kotlin/codegen/SourceInfo;", "(Lorg/jetbrains/kotlin/codegen/inline/SourceMapper;Ljava/util/List;Lorg/jetbrains/kotlin/codegen/SourceInfo;)V", "lastVisitedRange", "getParent", "()Lorg/jetbrains/kotlin/codegen/inline/SourceMapper;", "getRanges", "()Ljava/util/List;", "visitedLines", "Lgnu/trove/TIntIntHashMap;", "findMappingIfExists", "lineNumber", "", "mapLineNumber", "backend"})
public class NestedSourceMapper
extends DefaultSourceMapper {
    private final TIntIntHashMap visitedLines;
    private RangeMapping lastVisitedRange;
    @NotNull
    private final SourceMapper parent;
    @NotNull
    private final List<RangeMapping> ranges;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int mapLineNumber(int lineNumber) {
        int newLineNumber;
        RangeMapping rangeMapping;
        int n;
        int mappedLineNumber = this.visitedLines.get(lineNumber);
        if (mappedLineNumber > 0) {
            n = mappedLineNumber;
            return n;
        }
        RangeMapping rangeMapping2 = this.lastVisitedRange;
        if (rangeMapping2 != null && rangeMapping2.contains(lineNumber)) {
            rangeMapping = this.lastVisitedRange;
            if (rangeMapping == null) {
                Intrinsics.throwNpe();
            }
        } else {
            rangeMapping = this.findMappingIfExists(lineNumber);
        }
        if (rangeMapping == null) {
            String string = "Can't find range to map line " + lineNumber + " in " + this.getSourceInfo().getSource() + ": " + this.getSourceInfo().getPathOrCleanFQN();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        RangeMapping rangeForMapping = rangeMapping;
        int sourceLineNumber = rangeForMapping.mapDestToSource(lineNumber);
        SourceMapper sourceMapper = this.getParent();
        FileMapping fileMapping = rangeForMapping.getParent();
        if (fileMapping == null) {
            Intrinsics.throwNpe();
        }
        String string = fileMapping.getName();
        FileMapping fileMapping2 = rangeForMapping.getParent();
        if (fileMapping2 == null) {
            Intrinsics.throwNpe();
        }
        if ((newLineNumber = sourceMapper.mapLineNumber(sourceLineNumber, string, fileMapping2.getPath())) > 0) {
            this.visitedLines.put(lineNumber, newLineNumber);
        }
        this.lastVisitedRange = rangeForMapping;
        n = newLineNumber;
        return n;
    }

    private final RangeMapping findMappingIfExists(int lineNumber) {
        int index2 = CollectionsKt.binarySearch$default(this.ranges, (Object)new RangeMapping(lineNumber, lineNumber, 1, null, 8, null), (Comparator)findMappingIfExists.index.1.INSTANCE, (int)0, (int)0, (int)12, null);
        return index2 < 0 ? null : this.ranges.get(index2);
    }

    @Override
    @NotNull
    public SourceMapper getParent() {
        return this.parent;
    }

    @NotNull
    public final List<RangeMapping> getRanges() {
        return this.ranges;
    }

    public NestedSourceMapper(@NotNull SourceMapper parent2, @NotNull List<RangeMapping> ranges2, @NotNull SourceInfo sourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull(ranges2, (String)"ranges");
        Intrinsics.checkParameterIsNotNull((Object)sourceInfo, (String)"sourceInfo");
        super(sourceInfo);
        this.parent = parent2;
        this.ranges = ranges2;
        this.visitedLines = new TIntIntHashMap();
    }
}

