/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.FinallyBlocksLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.SuspendableNodesCollector;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.SuspendedTerminatorsCollector;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"collectSuspendableNodes", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "body", "suspendableNodes", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "throwableType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.js"})
public final class SuspendLoweringUtilsKt {
    @NotNull
    public static final IrBlock collectSuspendableNodes(@NotNull IrBlock body, @NotNull Set<IrElement> suspendableNodes, @NotNull CommonBackendContext context, @NotNull IrFunction function2, @NotNull IrType throwableType) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull(suspendableNodes, (String)"suspendableNodes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)throwableType, (String)"throwableType");
        IrElementVisitorVoidKt.acceptVoid(body, new SuspendableNodesCollector(suspendableNodes));
        SuspendedTerminatorsCollector terminatorsCollector = new SuspendedTerminatorsCollector(suspendableNodes);
        IrElementVisitorVoidKt.acceptVoid(body, terminatorsCollector);
        if (terminatorsCollector.getShouldFinalliesBeLowered()) {
            FinallyBlocksLowering finallyLower = new FinallyBlocksLowering(context, throwableType);
            function2.setBody(new IrBlockBodyImpl(body.getStartOffset(), body.getEndOffset(), body.getStatements()));
            function2.transform(finallyLower, null);
            IrBody irBody = function2.getBody();
            if (irBody == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
            }
            IrBlockBody newBody = (IrBlockBody)irBody;
            function2.setBody(null);
            suspendableNodes.clear();
            IrBlockImpl newBlock = JsIrBuilder.INSTANCE.buildBlock(body.getType(), newBody.getStatements());
            return SuspendLoweringUtilsKt.collectSuspendableNodes(newBlock, suspendableNodes, context, function2, throwableType);
        }
        return body;
    }
}

