/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.platform.base.BinaryTasksCollection;

public class BinaryTasksCollectionWrapper
implements BinaryTasksCollection {
    private final BinaryTasksCollection delegate;

    public BinaryTasksCollectionWrapper(BinaryTasksCollection delegate) {
        this.delegate = delegate;
    }

    public <T extends Task> T findSingleTaskWithType(Class<T> type) {
        DomainObjectSet<T> tasks = this.withType(type);
        if (tasks.size() == 0) {
            return null;
        }
        if (tasks.size() > 1) {
            throw new UnknownDomainObjectException(String.format("Multiple tasks with type '%s' found.", type.getSimpleName()));
        }
        return (T)((Task)tasks.iterator().next());
    }

    @Override
    public String taskName(String verb) {
        return this.delegate.taskName(verb);
    }

    @Override
    public String taskName(String verb, String object) {
        return this.delegate.taskName(verb, object);
    }

    @Override
    public Task getBuild() {
        return this.delegate.getBuild();
    }

    @Override
    public Task getCheck() {
        return this.delegate.getCheck();
    }

    @Override
    public <T extends Task> void create(String name, Class<T> type, Action<? super T> config) {
        this.delegate.create(name, type, config);
    }

    public <S extends Task> DomainObjectSet<S> withType(Class<S> type) {
        return this.delegate.withType(type);
    }

    public DomainObjectSet<Task> matching(Spec<? super Task> spec) {
        return this.delegate.matching(spec);
    }

    public DomainObjectSet<Task> matching(Closure spec) {
        return this.delegate.matching(spec);
    }

    public Set<Task> findAll(Closure spec) {
        return this.delegate.findAll(spec);
    }

    public <S extends Task> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        return this.delegate.withType(type, configureAction);
    }

    public <S extends Task> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        return this.delegate.withType(type, configureClosure);
    }

    public Action<? super Task> whenObjectAdded(Action<? super Task> action) {
        return this.delegate.whenObjectAdded(action);
    }

    public void whenObjectAdded(Closure action) {
        this.delegate.whenObjectAdded(action);
    }

    public Action<? super Task> whenObjectRemoved(Action<? super Task> action) {
        return this.delegate.whenObjectRemoved(action);
    }

    public void whenObjectRemoved(Closure action) {
        this.delegate.whenObjectRemoved(action);
    }

    public void all(Action<? super Task> action) {
        this.delegate.all(action);
    }

    public void all(Closure action) {
        this.delegate.all(action);
    }

    public void configureEach(Action<? super Task> action) {
        this.delegate.configureEach(action);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    public Iterator<Task> iterator() {
        return this.delegate.iterator();
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    public boolean add(Task task) {
        return this.delegate.add(task);
    }

    public void addLater(Provider<? extends Task> provider) {
        this.delegate.addLater(provider);
    }

    public void addAllLater(Provider<? extends Iterable<Task>> provider) {
        this.delegate.addAllLater(provider);
    }

    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    public boolean addAll(Collection<? extends Task> c) {
        return this.delegate.addAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

