/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.TextResourceInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.resource.TextResourceLoader;

public class ApiTextResourceAdapter
implements TextResourceInternal {
    private final URI uri;
    private final TextResourceLoader textResourceLoader;
    private final TemporaryFileProvider tempFileProvider;
    private TextResource textResource;

    public ApiTextResourceAdapter(TextResourceLoader textResourceLoader, TemporaryFileProvider tempFileProvider, URI uri) {
        this.uri = uri;
        this.textResourceLoader = textResourceLoader;
        this.tempFileProvider = tempFileProvider;
    }

    public String asString() {
        return this.getWrappedTextResource().getText();
    }

    public Reader asReader() {
        return this.getWrappedTextResource().getAsReader();
    }

    public File asFile(String targetCharset) {
        try {
            File file = this.getWrappedTextResource().getFile();
            if (file == null) {
                file = this.tempFileProvider.createTemporaryFile("wrappedInternalText", ".txt", "resource");
                Files.write((CharSequence)this.getWrappedTextResource().getText(), (File)file, (Charset)Charset.forName(targetCharset));
                return file;
            }
            Charset sourceCharset = this.getWrappedTextResource().getCharset();
            Charset targetCharsetObj = Charset.forName(targetCharset);
            if (targetCharsetObj.equals(sourceCharset)) {
                return file;
            }
            File targetFile = this.tempFileProvider.createTemporaryFile("uriTextResource", ".txt", "resource");
            try {
                Files.asCharSource((File)file, (Charset)sourceCharset).copyTo(Files.asCharSink((File)targetFile, (Charset)targetCharsetObj, (FileWriteMode[])new FileWriteMode[0]));
                return targetFile;
            }
            catch (IOException e) {
                throw new ResourceException("Could not write " + this.getDisplayName() + " content to " + targetFile + ".", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw ResourceExceptions.readFailed((String)this.getDisplayName(), (Throwable)e);
        }
    }

    public File asFile() {
        return this.asFile(Charset.defaultCharset().name());
    }

    public Object getInputProperties() {
        return this.uri;
    }

    public FileCollection getInputFiles() {
        return null;
    }

    public TaskDependency getBuildDependencies() {
        return TaskDependencyInternal.EMPTY;
    }

    public String getDisplayName() {
        return this.getWrappedTextResource().getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private TextResource getWrappedTextResource() {
        if (this.textResource == null) {
            this.textResource = this.textResourceLoader.loadUri("textResource", this.uri);
        }
        return this.textResource;
    }
}

