/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\r\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\u001e\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lorg/gradle/kotlin/dsl/concurrent/FutureContinuation;", "T", "Ljava/util/concurrent/Future;", "Lkotlin/coroutines/Continuation;", "context", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/coroutines/CoroutineContext;)V", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "outcomeLatch", "Ljava/util/concurrent/CountDownLatch;", "result", "Lkotlin/Result;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getOrThrow", "isCancelled", "isDone", "resumeWith", "", "(Ljava/lang/Object;)V", "gradle-kotlin-dsl"})
final class FutureContinuation<T>
implements Future<T>,
Continuation<T> {
    private Result<? extends T> result;
    private final CountDownLatch outcomeLatch;
    @NotNull
    private final CoroutineContext context;

    public void resumeWith(@NotNull Object result) {
        this.result = Result.box-impl((Object)result);
        this.outcomeLatch.countDown();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isDone() {
        return Intrinsics.areEqual(this.result, null) ^ true;
    }

    @Override
    public T get() {
        this.outcomeLatch.await();
        return this.getOrThrow();
    }

    @Override
    public T get(long timeout, @NotNull TimeUnit unit2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit2), (String)"unit");
        if (!this.outcomeLatch.await(timeout, unit2)) {
            throw (Throwable)new TimeoutException();
        }
        return this.getOrThrow();
    }

    private final T getOrThrow() {
        Result<? extends T> result = this.result;
        if (result == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Result<T>");
        }
        Object object = result.unbox-impl();
        boolean bl = false;
        ResultKt.throwOnFailure((Object)object);
        return (T)object;
    }

    @NotNull
    public CoroutineContext getContext() {
        return this.context;
    }

    public FutureContinuation(@NotNull CoroutineContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.outcomeLatch = new CountDownLatch(1);
    }
}

