/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.diagnostic;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.org.apache.log4j.Level;

public class DefaultLogger
extends Logger {
    private static boolean ourMirrorToStderr = true;

    public DefaultLogger(String category) {
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String message2) {
    }

    @Override
    public void debug(Throwable t) {
    }

    @Override
    public void debug(@NonNls String message2, Throwable t) {
    }

    @Override
    public void info(String message2) {
    }

    @Override
    public void info(String message2, Throwable t) {
    }

    @Override
    public void warn(@NonNls String message2, @Nullable Throwable t) {
        t = DefaultLogger.checkException(t);
        System.err.println("WARN: " + message2);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message2, @Nullable Throwable t, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(0);
        }
        t = DefaultLogger.checkException(t);
        message2 = message2 + DefaultLogger.attachmentsToString(t);
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message2);
            if (t != null) {
                t.printStackTrace(System.err);
            }
            if (details.length > 0) {
                System.err.println("details: ");
                for (String detail : details) {
                    System.err.println(detail);
                }
            }
        }
        AssertionError error = new AssertionError((Object)message2);
        ((Throwable)((Object)error)).initCause(t);
        throw error;
    }

    @Override
    public void setLevel(Level level) {
    }

    public static String attachmentsToString(@Nullable Throwable t) {
        Throwable rootCause;
        Throwable throwable = rootCause = t == null ? null : ExceptionUtil.getRootCause(t);
        if (rootCause instanceof ExceptionWithAttachments) {
            return "\n\nAttachments:\n" + StringUtil.join(((ExceptionWithAttachments)((Object)rootCause)).getAttachments(), ATTACHMENT_TO_STRING, "\n----\n");
        }
        return "";
    }

    public static boolean shouldDumpExceptionToStderr() {
        return ourMirrorToStderr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/DefaultLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "disableStderrDumping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

