/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformationResult;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.DisplayName;

class TransformingArtifactVisitor
implements ArtifactVisitor {
    private final ArtifactVisitor visitor;
    private final AttributeContainerInternal target;
    private final Map<ComponentArtifactIdentifier, TransformationResult> artifactResults;

    TransformingArtifactVisitor(ArtifactVisitor visitor, AttributeContainerInternal target, Map<ComponentArtifactIdentifier, TransformationResult> artifactResults) {
        this.visitor = visitor;
        this.target = target;
        this.artifactResults = artifactResults;
    }

    @Override
    public void visitArtifact(DisplayName variantName, AttributeContainer variantAttributes, ResolvableArtifact artifact) {
        TransformationResult result = this.artifactResults.get(artifact.getId());
        result.getTransformedSubject().ifSuccessfulOrElse(transformedSubject -> {
            for (File output : transformedSubject.getFiles()) {
                ResolvableArtifact resolvedArtifact = artifact.transformedTo(output);
                this.visitor.visitArtifact(variantName, (AttributeContainer)this.target, resolvedArtifact);
            }
            this.visitor.endVisitCollection(FileCollectionInternal.OTHER);
        }, failure -> this.visitor.visitFailure((Throwable)((Object)new TransformException(String.format("Failed to transform %s to match attributes %s.", artifact.getId(), this.target), (Throwable)failure))));
    }

    @Override
    public void visitFailure(Throwable failure) {
        this.visitor.visitFailure(failure);
    }

    @Override
    public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
        return this.visitor.prepareForVisit(source);
    }

    @Override
    public boolean requireArtifactFiles() {
        return this.visitor.requireArtifactFiles();
    }
}

