/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.instantiation.DeserializationInstantiator;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.generator.ConstructorSelector;
import org.gradle.internal.instantiation.generator.DependencyInjectingInstantiator;
import org.gradle.internal.service.ServiceLookup;
import sun.reflect.ReflectionFactory;

class DefaultInstantiationScheme
implements InstantiationScheme {
    private final DependencyInjectingInstantiator instantiator;
    private final ConstructorSelector constructorSelector;
    private final Set<Class<? extends Annotation>> injectionAnnotations;
    private final DeserializationInstantiator deserializationInstantiator;

    public DefaultInstantiationScheme(ConstructorSelector constructorSelector, ServiceLookup defaultServices, Set<Class<? extends Annotation>> injectionAnnotations, CrossBuildInMemoryCacheFactory cacheFactory) {
        this(constructorSelector, injectionAnnotations, new DependencyInjectingInstantiator(constructorSelector, defaultServices), new DefaultDeserializationInstantiator(constructorSelector, cacheFactory));
    }

    private DefaultInstantiationScheme(ConstructorSelector constructorSelector, Set<Class<? extends Annotation>> injectionAnnotations, DependencyInjectingInstantiator instantiator, DeserializationInstantiator deserializationInstantiator) {
        this.instantiator = instantiator;
        this.constructorSelector = constructorSelector;
        this.injectionAnnotations = injectionAnnotations;
        this.deserializationInstantiator = deserializationInstantiator;
    }

    @Override
    public Set<Class<? extends Annotation>> getInjectionAnnotations() {
        return this.injectionAnnotations;
    }

    @Override
    public <T> InstanceFactory<T> forType(Class<T> type) {
        return this.instantiator.factoryFor(type);
    }

    @Override
    public InstantiationScheme withServices(ServiceLookup services) {
        return new DefaultInstantiationScheme(this.constructorSelector, this.injectionAnnotations, new DependencyInjectingInstantiator(this.constructorSelector, services), this.deserializationInstantiator);
    }

    @Override
    public InstanceGenerator instantiator() {
        return this.instantiator;
    }

    @Override
    public DeserializationInstantiator deserializationInstantiator() {
        return this.deserializationInstantiator;
    }

    private static class DefaultDeserializationInstantiator
    implements DeserializationInstantiator {
        private final ConstructorSelector constructorSelector;
        private final CrossBuildInMemoryCache<Class<?>, Constructor<?>> constructorCache;

        public DefaultDeserializationInstantiator(ConstructorSelector constructorSelector, CrossBuildInMemoryCacheFactory cacheFactory) {
            this.constructorSelector = constructorSelector;
            this.constructorCache = cacheFactory.newClassCache();
        }

        @Override
        public <T> T newInstance(Class<T> implType, Class<? super T> baseClass) {
            try {
                Constructor constructor = (Constructor)this.constructorCache.get(implType, type -> {
                    try {
                        return ReflectionFactory.getReflectionFactory().newConstructorForSerialization(this.constructorSelector.forType(type).getGeneratedClass(), baseClass.getDeclaredConstructor(new Class[0]));
                    }
                    catch (NoSuchMethodException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                });
                return implType.cast(constructor.newInstance(new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw new ObjectInstantiationException(implType, e.getCause());
            }
            catch (Exception e) {
                throw new ObjectInstantiationException(implType, (Throwable)e);
            }
        }
    }
}

