/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

class ClassLoadingLocks {
    private final ConcurrentMap<String, WeakLockReference> myMap = new ConcurrentHashMap<String, WeakLockReference>();
    private final ReferenceQueue<Object> myQueue = new ReferenceQueue();

    ClassLoadingLocks() {
    }

    @NotNull
    Object getOrCreateLock(String className2) {
        WeakLockReference oldRef;
        Object lock;
        WeakLockReference lockReference = (WeakLockReference)this.myMap.get(className2);
        if (lockReference != null && (lock = lockReference.get()) != null) {
            Object t = lock;
            if (t == null) {
                ClassLoadingLocks.$$$reportNull$$$0(0);
            }
            return t;
        }
        Object newLock = new Object();
        WeakLockReference newRef = new WeakLockReference(className2, newLock, this.myQueue);
        do {
            this.processQueue();
            oldRef = this.myMap.putIfAbsent(className2, newRef);
            if (oldRef == null) {
                Object object = newLock;
                if (object == null) {
                    ClassLoadingLocks.$$$reportNull$$$0(1);
                }
                return object;
            }
            Object oldLock = oldRef.get();
            if (oldLock == null) continue;
            Object t = oldLock;
            if (t == null) {
                ClassLoadingLocks.$$$reportNull$$$0(2);
            }
            return t;
        } while (!this.myMap.replace(className2, oldRef, newRef));
        Object object = newLock;
        if (object == null) {
            ClassLoadingLocks.$$$reportNull$$$0(3);
        }
        return object;
    }

    private void processQueue() {
        WeakLockReference ref;
        while ((ref = (WeakLockReference)this.myQueue.poll()) != null) {
            this.myMap.remove(ref.myClassName, ref);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/lang/ClassLoadingLocks", "getOrCreateLock"));
    }

    private static class WeakLockReference
    extends WeakReference<Object> {
        final String myClassName;

        private WeakLockReference(@NotNull String className2, Object lock, ReferenceQueue<Object> q) {
            if (className2 == null) {
                WeakLockReference.$$$reportNull$$$0(0);
            }
            super(lock, q);
            this.myClassName = className2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/com/intellij/util/lang/ClassLoadingLocks$WeakLockReference", "<init>"));
        }
    }
}

