/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ManagedFactories;
import org.gradle.api.internal.file.collections.UnpackingVisitor;
import org.gradle.api.internal.provider.HasConfigurableValueInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.state.Managed;
import org.gradle.util.DeprecationLogger;

public class DefaultConfigurableFileCollection
extends CompositeFileCollection
implements ConfigurableFileCollection,
Managed,
HasConfigurableValueInternal {
    private final Set<Object> files;
    private final PathSet filesWrapper;
    private final String displayName;
    private final PathToFileResolver resolver;
    private final DefaultTaskDependency buildDependency;
    private State state = State.Mutable;
    private boolean disallowChanges;

    public DefaultConfigurableFileCollection(@Nullable String displayName, PathToFileResolver fileResolver, TaskDependencyFactory dependencyFactory, Collection<?> files) {
        this.displayName = displayName;
        this.resolver = fileResolver;
        this.files = new LinkedHashSet<Object>();
        this.files.addAll(files);
        this.filesWrapper = new PathSet(this.files);
        this.buildDependency = dependencyFactory.configurableDependency();
    }

    public boolean immutable() {
        return false;
    }

    public Class<?> publicType() {
        return ConfigurableFileCollection.class;
    }

    public Object unpackState() {
        return this.getFiles();
    }

    public void finalizeValue() {
        if (this.state != State.Final) {
            this.calculateFinalizedValue();
        }
        this.state = State.Final;
        this.disallowChanges = true;
    }

    public void disallowChanges() {
        this.disallowChanges = true;
    }

    public void implicitFinalizeValue() {
        if (this.state == State.Mutable) {
            this.state = State.FinalizeNextQuery;
        }
    }

    public int getFactoryId() {
        return ManagedFactories.ConfigurableFileCollectionManagedFactory.FACTORY_ID;
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? "file collection" : this.displayName;
    }

    public Set<Object> getFrom() {
        return this.filesWrapper;
    }

    public void setFrom(Iterable<?> path) {
        if (this.assertMutable()) {
            this.files.clear();
            this.files.add(path);
        }
    }

    public void setFrom(Object ... paths) {
        if (this.assertMutable()) {
            this.files.clear();
            Collections.addAll(this.files, paths);
        }
    }

    public ConfigurableFileCollection from(Object ... paths) {
        if (this.assertMutable()) {
            Collections.addAll(this.files, paths);
        }
        return this;
    }

    private boolean assertMutable() {
        if (this.state == State.Final && this.disallowChanges) {
            throw new IllegalStateException("The value for " + this.displayNameForThisCollection() + " is final and cannot be changed.");
        }
        if (this.disallowChanges) {
            throw new IllegalStateException("The value for " + this.displayNameForThisCollection() + " cannot be changed.");
        }
        if (this.state == State.Final) {
            DeprecationLogger.nagUserOfDiscontinuedInvocation((String)"Changing the value for a FileCollection with a final value");
            return false;
        }
        return true;
    }

    private String displayNameForThisCollection() {
        return this.displayName == null ? "this file collection" : this.displayName;
    }

    public ConfigurableFileCollection builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    public Set<Object> getBuiltBy() {
        return this.buildDependency.getMutableValues();
    }

    public ConfigurableFileCollection setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }

    private void calculateFinalizedValue() {
        DefaultFileCollectionResolveContext context = new DefaultFileCollectionResolveContext((Factory<PatternSet>)PatternSets.getNonCachingPatternSetFactory());
        UnpackingVisitor nested = new UnpackingVisitor(context, this.resolver);
        nested.add(this.files);
        this.files.clear();
        this.files.addAll(context.resolveAsFileCollections());
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        if (this.state == State.FinalizeNextQuery) {
            this.calculateFinalizedValue();
            this.state = State.Final;
        }
        if (this.state == State.Final) {
            context.addAll(this.files);
        } else {
            UnpackingVisitor nested = new UnpackingVisitor(context, this.resolver);
            nested.add(this.files);
        }
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.buildDependency);
        super.visitDependencies(context);
    }

    private class PathSet
    extends AbstractSet<Object> {
        private final Set<Object> delegate;

        public PathSet(Set<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<Object> iterator() {
            final Iterator<Object> iterator = this.delegate.iterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    if (DefaultConfigurableFileCollection.this.assertMutable()) {
                        iterator.remove();
                    }
                }
            };
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean add(Object o) {
            if (DefaultConfigurableFileCollection.this.assertMutable()) {
                return this.delegate.add(o);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (DefaultConfigurableFileCollection.this.assertMutable()) {
                return this.delegate.remove(o);
            }
            return false;
        }

        @Override
        public void clear() {
            if (DefaultConfigurableFileCollection.this.assertMutable()) {
                this.delegate.clear();
            }
        }
    }

    private static enum State {
        Mutable,
        FinalizeNextQuery,
        Final;

    }
}

